/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.DeviceAuthorization;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuth2AccessTokenErrorResponse;
import com.github.scribejava.core.model.OAuth2Authorization;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.AccessTokenRequestParams;
import com.github.scribejava.core.oauth.AuthorizationUrlBuilder;
import com.github.scribejava.core.oauth.OAuthService;
import com.github.scribejava.core.oauth2.OAuth2Error;
import com.github.scribejava.core.pkce.PKCE;
import com.github.scribejava.core.revoke.TokenTypeHint;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class OAuth20Service
extends OAuthService {
    private static final String VERSION = "2.0";
    private final DefaultApi20 api;
    private final String responseType;
    private final String defaultScope;

    public OAuth20Service(DefaultApi20 api, String apiKey, String apiSecret, String callback, String defaultScope, String responseType, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        super(apiKey, apiSecret, callback, debugStream, userAgent, httpClientConfig, httpClient);
        this.responseType = responseType;
        this.api = api;
        this.defaultScope = defaultScope;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public void signRequest(String accessToken, OAuthRequest request) {
        this.api.getBearerSignature().signRequest(accessToken, request);
    }

    public void signRequest(OAuth2AccessToken accessToken, OAuthRequest request) {
        this.signRequest(accessToken == null ? null : accessToken.getAccessToken(), request);
    }

    public String getAuthorizationUrl() {
        return this.createAuthorizationUrlBuilder().build();
    }

    public String getAuthorizationUrl(String state) {
        return this.createAuthorizationUrlBuilder().state(state).build();
    }

    public String getAuthorizationUrl(Map<String, String> additionalParams) {
        return this.createAuthorizationUrlBuilder().additionalParams(additionalParams).build();
    }

    public String getAuthorizationUrl(PKCE pkce) {
        return this.createAuthorizationUrlBuilder().pkce(pkce).build();
    }

    public AuthorizationUrlBuilder createAuthorizationUrlBuilder() {
        return new AuthorizationUrlBuilder(this);
    }

    public DefaultApi20 getApi() {
        return this.api;
    }

    public OAuth2Authorization extractAuthorization(String redirectLocation) {
        OAuth2Authorization authorization = new OAuth2Authorization();
        int end = redirectLocation.indexOf(35);
        if (end == -1) {
            end = redirectLocation.length();
        }
        for (String param : redirectLocation.substring(redirectLocation.indexOf(63) + 1, end).split("&")) {
            String[] keyValue = param.split("=");
            if (keyValue.length != 2) continue;
            try {
                switch (keyValue[0]) {
                    case "code": {
                        authorization.setCode(URLDecoder.decode(keyValue[1], "UTF-8"));
                        break;
                    }
                    case "state": {
                        authorization.setState(URLDecoder.decode(keyValue[1], "UTF-8"));
                        break;
                    }
                }
            }
            catch (UnsupportedEncodingException ueE) {
                throw new IllegalStateException("jvm without UTF-8, really?", ueE);
            }
        }
        return authorization;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getDefaultScope() {
        return this.defaultScope;
    }

    protected void logRequestWithParams(String requestDescription, OAuthRequest request) {
        if (this.isDebug()) {
            this.log("created " + requestDescription + " request with body params [%s], query string params [%s]", request.getBodyParams().asFormUrlEncodedString(), request.getQueryStringParams().asFormUrlEncodedString());
        }
    }

    protected OAuth2AccessToken sendAccessTokenRequestSync(OAuthRequest request) throws IOException, InterruptedException, ExecutionException {
        if (this.isDebug()) {
            this.log("send request for access token synchronously to %s", request.getCompleteUrl());
        }
        try (Response response = this.execute(request);){
            if (this.isDebug()) {
                this.log("response status code: %s", response.getCode());
                this.log("response body: %s", response.getBody());
            }
            OAuth2AccessToken oAuth2AccessToken = this.api.getAccessTokenExtractor().extract(response);
            return oAuth2AccessToken;
        }
    }

    protected Future<OAuth2AccessToken> sendAccessTokenRequestAsync(OAuthRequest request) {
        return this.sendAccessTokenRequestAsync(request, null);
    }

    protected Future<OAuth2AccessToken> sendAccessTokenRequestAsync(OAuthRequest request, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        if (this.isDebug()) {
            this.log("send request for access token asynchronously to %s", request.getCompleteUrl());
        }
        return this.execute(request, callback, new OAuthRequest.ResponseConverter<OAuth2AccessToken>(){

            @Override
            public OAuth2AccessToken convert(Response response) throws IOException {
                OAuth20Service.this.log("received response for access token");
                if (OAuth20Service.this.isDebug()) {
                    OAuth20Service.this.log("response status code: %s", response.getCode());
                    OAuth20Service.this.log("response body: %s", response.getBody());
                }
                OAuth2AccessToken token = OAuth20Service.this.api.getAccessTokenExtractor().extract(response);
                response.close();
                return token;
            }
        });
    }

    protected OAuthRequest createAccessTokenRequest(AccessTokenRequestParams params) {
        Map<String, String> extraParameters;
        String scope;
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        this.api.getClientAuthentication().addClientAuthentication(request, this.getApiKey(), this.getApiSecret());
        request.addParameter("code", params.getCode());
        String callback = this.getCallback();
        if (callback != null) {
            request.addParameter("redirect_uri", callback);
        }
        if ((scope = params.getScope()) != null) {
            request.addParameter("scope", scope);
        } else if (this.defaultScope != null) {
            request.addParameter("scope", this.defaultScope);
        }
        request.addParameter("grant_type", "authorization_code");
        String pkceCodeVerifier = params.getPkceCodeVerifier();
        if (pkceCodeVerifier != null) {
            request.addParameter("code_verifier", pkceCodeVerifier);
        }
        if ((extraParameters = params.getExtraParameters()) != null && !extraParameters.isEmpty()) {
            for (Map.Entry<String, String> extraParameter : extraParameters.entrySet()) {
                request.addParameter(extraParameter.getKey(), extraParameter.getValue());
            }
        }
        this.logRequestWithParams("access token", request);
        return request;
    }

    public Future<OAuth2AccessToken> getAccessTokenAsync(String code) {
        return this.getAccessToken(AccessTokenRequestParams.create(code), null);
    }

    public Future<OAuth2AccessToken> getAccessTokenAsync(AccessTokenRequestParams params) {
        return this.getAccessToken(params, null);
    }

    public OAuth2AccessToken getAccessToken(String code) throws IOException, InterruptedException, ExecutionException {
        return this.getAccessToken(AccessTokenRequestParams.create(code));
    }

    public OAuth2AccessToken getAccessToken(AccessTokenRequestParams params) throws IOException, InterruptedException, ExecutionException {
        return this.sendAccessTokenRequestSync(this.createAccessTokenRequest(params));
    }

    public Future<OAuth2AccessToken> getAccessToken(AccessTokenRequestParams params, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        return this.sendAccessTokenRequestAsync(this.createAccessTokenRequest(params), callback);
    }

    public Future<OAuth2AccessToken> getAccessToken(String code, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        return this.getAccessToken(AccessTokenRequestParams.create(code), callback);
    }

    protected OAuthRequest createRefreshTokenRequest(String refreshToken, String scope) {
        if (refreshToken == null || refreshToken.isEmpty()) {
            throw new IllegalArgumentException("The refreshToken cannot be null or empty");
        }
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getRefreshTokenEndpoint());
        this.api.getClientAuthentication().addClientAuthentication(request, this.getApiKey(), this.getApiSecret());
        if (scope != null) {
            request.addParameter("scope", scope);
        } else if (this.defaultScope != null) {
            request.addParameter("scope", this.defaultScope);
        }
        request.addParameter("refresh_token", refreshToken);
        request.addParameter("grant_type", "refresh_token");
        this.logRequestWithParams("refresh token", request);
        return request;
    }

    public Future<OAuth2AccessToken> refreshAccessTokenAsync(String refreshToken) {
        return this.refreshAccessToken(refreshToken, (OAuthAsyncRequestCallback<OAuth2AccessToken>)null);
    }

    public Future<OAuth2AccessToken> refreshAccessTokenAsync(String refreshToken, String scope) {
        return this.refreshAccessToken(refreshToken, scope, null);
    }

    public OAuth2AccessToken refreshAccessToken(String refreshToken) throws IOException, InterruptedException, ExecutionException {
        return this.refreshAccessToken(refreshToken, (String)null);
    }

    public OAuth2AccessToken refreshAccessToken(String refreshToken, String scope) throws IOException, InterruptedException, ExecutionException {
        OAuthRequest request = this.createRefreshTokenRequest(refreshToken, scope);
        return this.sendAccessTokenRequestSync(request);
    }

    public Future<OAuth2AccessToken> refreshAccessToken(String refreshToken, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuthRequest request = this.createRefreshTokenRequest(refreshToken, null);
        return this.sendAccessTokenRequestAsync(request, callback);
    }

    public Future<OAuth2AccessToken> refreshAccessToken(String refreshToken, String scope, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuthRequest request = this.createRefreshTokenRequest(refreshToken, scope);
        return this.sendAccessTokenRequestAsync(request, callback);
    }

    protected OAuthRequest createAccessTokenPasswordGrantRequest(String username, String password, String scope) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        request.addParameter("username", username);
        request.addParameter("password", password);
        if (scope != null) {
            request.addParameter("scope", scope);
        } else if (this.defaultScope != null) {
            request.addParameter("scope", this.defaultScope);
        }
        request.addParameter("grant_type", "password");
        this.api.getClientAuthentication().addClientAuthentication(request, this.getApiKey(), this.getApiSecret());
        this.logRequestWithParams("access token password grant", request);
        return request;
    }

    public OAuth2AccessToken getAccessTokenPasswordGrant(String username, String password) throws IOException, InterruptedException, ExecutionException {
        OAuthRequest request = this.createAccessTokenPasswordGrantRequest(username, password, null);
        return this.sendAccessTokenRequestSync(request);
    }

    public OAuth2AccessToken getAccessTokenPasswordGrant(String username, String password, String scope) throws IOException, InterruptedException, ExecutionException {
        OAuthRequest request = this.createAccessTokenPasswordGrantRequest(username, password, scope);
        return this.sendAccessTokenRequestSync(request);
    }

    public Future<OAuth2AccessToken> getAccessTokenPasswordGrantAsync(String username, String password) {
        return this.getAccessTokenPasswordGrantAsync(username, password, (OAuthAsyncRequestCallback<OAuth2AccessToken>)null);
    }

    public Future<OAuth2AccessToken> getAccessTokenPasswordGrantAsync(String username, String password, String scope) {
        return this.getAccessTokenPasswordGrantAsync(username, password, scope, null);
    }

    public Future<OAuth2AccessToken> getAccessTokenPasswordGrantAsync(String username, String password, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuthRequest request = this.createAccessTokenPasswordGrantRequest(username, password, null);
        return this.sendAccessTokenRequestAsync(request, callback);
    }

    public Future<OAuth2AccessToken> getAccessTokenPasswordGrantAsync(String username, String password, String scope, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuthRequest request = this.createAccessTokenPasswordGrantRequest(username, password, scope);
        return this.sendAccessTokenRequestAsync(request, callback);
    }

    protected OAuthRequest createAccessTokenClientCredentialsGrantRequest(String scope) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        this.api.getClientAuthentication().addClientAuthentication(request, this.getApiKey(), this.getApiSecret());
        if (scope != null) {
            request.addParameter("scope", scope);
        } else if (this.defaultScope != null) {
            request.addParameter("scope", this.defaultScope);
        }
        request.addParameter("grant_type", "client_credentials");
        this.logRequestWithParams("access token client credentials grant", request);
        return request;
    }

    public Future<OAuth2AccessToken> getAccessTokenClientCredentialsGrantAsync() {
        return this.getAccessTokenClientCredentialsGrant((OAuthAsyncRequestCallback<OAuth2AccessToken>)null);
    }

    public Future<OAuth2AccessToken> getAccessTokenClientCredentialsGrantAsync(String scope) {
        return this.getAccessTokenClientCredentialsGrant(scope, null);
    }

    public OAuth2AccessToken getAccessTokenClientCredentialsGrant() throws IOException, InterruptedException, ExecutionException {
        OAuthRequest request = this.createAccessTokenClientCredentialsGrantRequest(null);
        return this.sendAccessTokenRequestSync(request);
    }

    public OAuth2AccessToken getAccessTokenClientCredentialsGrant(String scope) throws IOException, InterruptedException, ExecutionException {
        OAuthRequest request = this.createAccessTokenClientCredentialsGrantRequest(scope);
        return this.sendAccessTokenRequestSync(request);
    }

    public Future<OAuth2AccessToken> getAccessTokenClientCredentialsGrant(OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuthRequest request = this.createAccessTokenClientCredentialsGrantRequest(null);
        return this.sendAccessTokenRequestAsync(request, callback);
    }

    public Future<OAuth2AccessToken> getAccessTokenClientCredentialsGrant(String scope, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuthRequest request = this.createAccessTokenClientCredentialsGrantRequest(scope);
        return this.sendAccessTokenRequestAsync(request, callback);
    }

    protected OAuthRequest createRevokeTokenRequest(String tokenToRevoke, TokenTypeHint tokenTypeHint) {
        OAuthRequest request = new OAuthRequest(Verb.POST, this.api.getRevokeTokenEndpoint());
        this.api.getClientAuthentication().addClientAuthentication(request, this.getApiKey(), this.getApiSecret());
        request.addParameter("token", tokenToRevoke);
        if (tokenTypeHint != null) {
            request.addParameter("token_type_hint", tokenTypeHint.getValue());
        }
        this.logRequestWithParams("revoke token", request);
        return request;
    }

    public Future<Void> revokeTokenAsync(String tokenToRevoke) {
        return this.revokeTokenAsync(tokenToRevoke, null);
    }

    public Future<Void> revokeTokenAsync(String tokenToRevoke, TokenTypeHint tokenTypeHint) {
        return this.revokeToken(tokenToRevoke, null, tokenTypeHint);
    }

    public void revokeToken(String tokenToRevoke) throws IOException, InterruptedException, ExecutionException {
        this.revokeToken(tokenToRevoke, (TokenTypeHint)null);
    }

    public void revokeToken(String tokenToRevoke, TokenTypeHint tokenTypeHint) throws IOException, InterruptedException, ExecutionException {
        OAuthRequest request = this.createRevokeTokenRequest(tokenToRevoke, tokenTypeHint);
        try (Response response = this.execute(request);){
            this.checkForErrorRevokeToken(response);
        }
    }

    public Future<Void> revokeToken(String tokenToRevoke, OAuthAsyncRequestCallback<Void> callback) {
        return this.revokeToken(tokenToRevoke, callback, null);
    }

    public Future<Void> revokeToken(String tokenToRevoke, OAuthAsyncRequestCallback<Void> callback, TokenTypeHint tokenTypeHint) {
        OAuthRequest request = this.createRevokeTokenRequest(tokenToRevoke, tokenTypeHint);
        return this.execute(request, callback, new OAuthRequest.ResponseConverter<Void>(){

            @Override
            public Void convert(Response response) throws IOException {
                OAuth20Service.this.checkForErrorRevokeToken(response);
                response.close();
                return null;
            }
        });
    }

    private void checkForErrorRevokeToken(Response response) throws IOException {
        if (response.getCode() != 200) {
            OAuth2AccessTokenJsonExtractor.instance().generateError(response);
        }
    }

    protected OAuthRequest createDeviceAuthorizationCodesRequest(String scope) {
        OAuthRequest request = new OAuthRequest(Verb.POST, this.api.getDeviceAuthorizationEndpoint());
        request.addParameter("client_id", this.getApiKey());
        if (scope != null) {
            request.addParameter("scope", scope);
        } else if (this.defaultScope != null) {
            request.addParameter("scope", this.defaultScope);
        }
        this.logRequestWithParams("Device Authorization Codes", request);
        return request;
    }

    public DeviceAuthorization getDeviceAuthorizationCodes() throws InterruptedException, ExecutionException, IOException {
        return this.getDeviceAuthorizationCodes((String)null);
    }

    public DeviceAuthorization getDeviceAuthorizationCodes(String scope) throws InterruptedException, ExecutionException, IOException {
        OAuthRequest request = this.createDeviceAuthorizationCodesRequest(scope);
        try (Response response = this.execute(request);){
            if (this.isDebug()) {
                this.log("got DeviceAuthorizationCodes response");
                this.log("response status code: %s", response.getCode());
                this.log("response body: %s", response.getBody());
            }
            DeviceAuthorization deviceAuthorization = this.api.getDeviceAuthorizationExtractor().extract(response);
            return deviceAuthorization;
        }
    }

    public Future<DeviceAuthorization> getDeviceAuthorizationCodes(OAuthAsyncRequestCallback<DeviceAuthorization> callback) {
        return this.getDeviceAuthorizationCodes(null, callback);
    }

    public Future<DeviceAuthorization> getDeviceAuthorizationCodes(String scope, OAuthAsyncRequestCallback<DeviceAuthorization> callback) {
        OAuthRequest request = this.createDeviceAuthorizationCodesRequest(scope);
        return this.execute(request, callback, new OAuthRequest.ResponseConverter<DeviceAuthorization>(){

            @Override
            public DeviceAuthorization convert(Response response) throws IOException {
                DeviceAuthorization deviceAuthorization = OAuth20Service.this.api.getDeviceAuthorizationExtractor().extract(response);
                response.close();
                return deviceAuthorization;
            }
        });
    }

    public Future<DeviceAuthorization> getDeviceAuthorizationCodesAsync() {
        return this.getDeviceAuthorizationCodesAsync(null);
    }

    public Future<DeviceAuthorization> getDeviceAuthorizationCodesAsync(String scope) {
        return this.getDeviceAuthorizationCodes(scope, null);
    }

    protected OAuthRequest createAccessTokenDeviceAuthorizationGrantRequest(DeviceAuthorization deviceAuthorization) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        request.addParameter("grant_type", "urn:ietf:params:oauth:grant-type:device_code");
        request.addParameter("device_code", deviceAuthorization.getDeviceCode());
        this.api.getClientAuthentication().addClientAuthentication(request, this.getApiKey(), this.getApiSecret());
        return request;
    }

    public OAuth2AccessToken getAccessTokenDeviceAuthorizationGrant(DeviceAuthorization deviceAuthorization) throws InterruptedException, ExecutionException, IOException {
        OAuthRequest request = this.createAccessTokenDeviceAuthorizationGrantRequest(deviceAuthorization);
        try (Response response = this.execute(request);){
            if (this.isDebug()) {
                this.log("got AccessTokenDeviceAuthorizationGrant response");
                this.log("response status code: %s", response.getCode());
                this.log("response body: %s", response.getBody());
            }
            OAuth2AccessToken oAuth2AccessToken = this.api.getAccessTokenExtractor().extract(response);
            return oAuth2AccessToken;
        }
    }

    public Future<OAuth2AccessToken> getAccessTokenDeviceAuthorizationGrant(DeviceAuthorization deviceAuthorization, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuthRequest request = this.createAccessTokenDeviceAuthorizationGrantRequest(deviceAuthorization);
        return this.execute(request, callback, new OAuthRequest.ResponseConverter<OAuth2AccessToken>(){

            @Override
            public OAuth2AccessToken convert(Response response) throws IOException {
                OAuth2AccessToken accessToken = OAuth20Service.this.api.getAccessTokenExtractor().extract(response);
                response.close();
                return accessToken;
            }
        });
    }

    public Future<OAuth2AccessToken> getAccessTokenDeviceAuthorizationGrantAsync(DeviceAuthorization deviceAuthorization) {
        return this.getAccessTokenDeviceAuthorizationGrant(deviceAuthorization, null);
    }

    public OAuth2AccessToken pollAccessTokenDeviceAuthorizationGrant(DeviceAuthorization deviceAuthorization) throws InterruptedException, ExecutionException, IOException {
        long intervalMillis = deviceAuthorization.getIntervalSeconds() * 1000;
        while (true) {
            try {
                return this.getAccessTokenDeviceAuthorizationGrant(deviceAuthorization);
            }
            catch (OAuth2AccessTokenErrorResponse e) {
                if (e.getError() != OAuth2Error.AUTHORIZATION_PENDING) {
                    if (e.getError() == OAuth2Error.SLOW_DOWN) {
                        intervalMillis += 5000L;
                    } else {
                        throw e;
                    }
                }
                Thread.sleep(intervalMillis);
                continue;
            }
            break;
        }
    }
}

