/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.addtrackstoplaylist;

import com.nodepit.nodes.spotify.v1.LabelButton;
import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.operation.addtrackstoplaylist.AddTracksToPlaylistNodeSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class AddTracksToPlaylistNodeDialog
extends NodeDialogPane {
    private final AddTracksToPlaylistNodeSettings nodeSettings = new AddTracksToPlaylistNodeSettings();
    private JTextField playlistId;
    private JSpinner position;
    private JCheckBox positionEnabled;
    private JTextField uris;
    private JCheckBox urisEnabled;
    private RTextScrollPane body;
    private JComboBox<ResponseMapper> resultFormat;

    AddTracksToPlaylistNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Playlist Id:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.playlistId = new JTextField(30);
        panel.add((Component)this.playlistId, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Position:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.positionEnabled = new JCheckBox();
        this.positionEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.positionEnabled.setSelected(!this.positionEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.positionEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.position = new JSpinner(new SpinnerNumberModel(AddTracksToPlaylistNodeSettings.POSITION_DEFAULT_VALUE, AddTracksToPlaylistNodeSettings.POSITION_MINIMUM_VALUE, AddTracksToPlaylistNodeSettings.POSITION_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.position, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Uris:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.urisEnabled = new JCheckBox();
        this.urisEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.urisEnabled.setSelected(!this.urisEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.urisEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.uris = new JTextField(30);
        panel.add((Component)this.uris, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Body:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        RSyntaxTextArea textArea3 = new RSyntaxTextArea();
        textArea3.setCodeFoldingEnabled(true);
        textArea3.setSyntaxEditingStyle("text/json");
        textArea3.setAntiAliasingEnabled(true);
        this.body = new RTextScrollPane((RTextArea)textArea3);
        this.body.setPreferredSize(new Dimension(400, 300));
        panel.add((Component)this.body, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(AddTracksToPlaylistNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.position.setEnabled(this.positionEnabled.isSelected());
        this.uris.setEnabled(this.urisEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.playlistId(this.playlistId.getText());
        this.nodeSettings.position((Integer)this.position.getValue());
        this.nodeSettings.positionEnabled(this.positionEnabled.isSelected());
        this.nodeSettings.uris(this.uris.getText());
        this.nodeSettings.urisEnabled(this.urisEnabled.isSelected());
        this.nodeSettings.body(this.body.getTextArea().getText());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.playlistId.setText(this.nodeSettings.playlistId());
        this.position.setValue(this.nodeSettings.position());
        this.positionEnabled.setSelected(this.nodeSettings.positionEnabled());
        this.uris.setText(this.nodeSettings.uris());
        this.urisEnabled.setSelected(this.nodeSettings.urisEnabled());
        this.body.getTextArea().setText(this.nodeSettings.body());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

