/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.addtrackstoplaylist;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import com.nodepit.nodes.spotify.v1.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class AddTracksToPlaylistNodeSettings {
    private static final String PLAYLIST_ID_KEY = "playlistId";
    private static final String PLAYLIST_ID_DEFAULT_VALUE = null;
    private String playlistId = PLAYLIST_ID_DEFAULT_VALUE;
    private static final String POSITION_KEY = "position";
    static final Integer POSITION_DEFAULT_VALUE = 0;
    static final Integer POSITION_MINIMUM_VALUE = null;
    static final Integer POSITION_MAXIMUM_VALUE = null;
    private int position = POSITION_DEFAULT_VALUE;
    private static final String POSITION_ENABLED_KEY = "positionEnabled";
    private boolean positionEnabled = false;
    private static final String URIS_KEY = "uris";
    private static final String URIS_DEFAULT_VALUE = null;
    private String uris = URIS_DEFAULT_VALUE;
    private static final String URIS_ENABLED_KEY = "urisEnabled";
    private boolean urisEnabled = false;
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", AddTracksToPlaylistNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"snapshot_id\":\"rows[0][0]\"}}]").addBodyColumn(new DataColumnSpecCreator("Snapshot Id", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    AddTracksToPlaylistNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(PLAYLIST_ID_KEY, this.playlistId);
        settings.addInt(POSITION_KEY, this.position);
        settings.addBoolean(POSITION_ENABLED_KEY, this.positionEnabled);
        settings.addString(URIS_KEY, this.uris);
        settings.addBoolean(URIS_ENABLED_KEY, this.urisEnabled);
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.playlistId = settings.getString(PLAYLIST_ID_KEY, PLAYLIST_ID_DEFAULT_VALUE);
        this.position = settings.getInt(POSITION_KEY, POSITION_DEFAULT_VALUE.intValue());
        this.positionEnabled = settings.getBoolean(POSITION_ENABLED_KEY, false);
        this.uris = settings.getString(URIS_KEY, URIS_DEFAULT_VALUE);
        this.urisEnabled = settings.getBoolean(URIS_ENABLED_KEY, false);
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.playlistId == null || this.playlistId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cPlaylist Id\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String playlistId() {
        return this.playlistId;
    }

    void playlistId(String value) {
        this.playlistId = value;
    }

    int position() {
        return this.position;
    }

    void position(int value) {
        this.position = value;
    }

    boolean positionEnabled() {
        return this.positionEnabled;
    }

    void positionEnabled(boolean value) {
        this.positionEnabled = value;
    }

    String uris() {
        return this.uris;
    }

    void uris(String value) {
        this.uris = value;
    }

    boolean urisEnabled() {
        return this.urisEnabled;
    }

    void urisEnabled(boolean value) {
        this.urisEnabled = value;
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

