/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getplaylist;

import com.nodepit.nodes.spotify.v1.LabelButton;
import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.operation.getplaylist.GetPlaylistNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class GetPlaylistNodeDialog
extends NodeDialogPane {
    private final GetPlaylistNodeSettings nodeSettings = new GetPlaylistNodeSettings();
    private JTextField playlistId;
    private JTextField market;
    private JCheckBox marketEnabled;
    private JTextField fields;
    private JCheckBox fieldsEnabled;
    private JTextField additionalTypes;
    private JCheckBox additionalTypesEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    GetPlaylistNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Playlist Id:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.playlistId = new JTextField(30);
        panel.add((Component)this.playlistId, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Market:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.marketEnabled = new JCheckBox();
        this.marketEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.marketEnabled.setSelected(!this.marketEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.marketEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.market = new JTextField(30);
        panel.add((Component)this.market, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Fields:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.fieldsEnabled = new JCheckBox();
        this.fieldsEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.fieldsEnabled.setSelected(!this.fieldsEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.fieldsEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.fields = new JTextField(30);
        panel.add((Component)this.fields, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label3 = new LabelButton("Additional Types:");
        panel.add((Component)label3, c);
        ++c.gridx;
        c.anchor = 17;
        this.additionalTypesEnabled = new JCheckBox();
        this.additionalTypesEnabled.addActionListener(e -> this.updateComponents());
        label3.addActionListener(e -> {
            this.additionalTypesEnabled.setSelected(!this.additionalTypesEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.additionalTypesEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.additionalTypes = new JTextField(30);
        panel.add((Component)this.additionalTypes, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(GetPlaylistNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.market.setEnabled(this.marketEnabled.isSelected());
        this.fields.setEnabled(this.fieldsEnabled.isSelected());
        this.additionalTypes.setEnabled(this.additionalTypesEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.playlistId(this.playlistId.getText());
        this.nodeSettings.market(this.market.getText());
        this.nodeSettings.marketEnabled(this.marketEnabled.isSelected());
        this.nodeSettings.fields(this.fields.getText());
        this.nodeSettings.fieldsEnabled(this.fieldsEnabled.isSelected());
        this.nodeSettings.additionalTypes(this.additionalTypes.getText());
        this.nodeSettings.additionalTypesEnabled(this.additionalTypesEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.playlistId.setText(this.nodeSettings.playlistId());
        this.market.setText(this.nodeSettings.market());
        this.marketEnabled.setSelected(this.nodeSettings.marketEnabled());
        this.fields.setText(this.nodeSettings.fields());
        this.fieldsEnabled.setSelected(this.nodeSettings.fieldsEnabled());
        this.additionalTypes.setText(this.nodeSettings.additionalTypes());
        this.additionalTypesEnabled.setSelected(this.nodeSettings.additionalTypesEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

