/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getplaylistcover;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetPlaylistCoverNodeSettings {
    private static final String PLAYLIST_ID_KEY = "playlistId";
    private static final String PLAYLIST_ID_DEFAULT_VALUE = null;
    private String playlistId = PLAYLIST_ID_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"*\":{\"url\":\"rows[#2][0]\",\"height\":\"rows[#2][1]\",\"width\":\"rows[#2][2]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Url", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Height", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Width", LongCell.LongCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetPlaylistCoverNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(PLAYLIST_ID_KEY, this.playlistId);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.playlistId = settings.getString(PLAYLIST_ID_KEY, PLAYLIST_ID_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.playlistId == null || this.playlistId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cPlaylist Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String playlistId() {
        return this.playlistId;
    }

    void playlistId(String value) {
        this.playlistId = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

