/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getrecentlyplayed;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetRecentlyPlayedNodeSettings {
    private static final String LIMIT_KEY = "limit";
    static final Integer LIMIT_DEFAULT_VALUE = 20;
    static final Integer LIMIT_MINIMUM_VALUE = 1;
    static final Integer LIMIT_MAXIMUM_VALUE = 50;
    private int limit = LIMIT_DEFAULT_VALUE;
    private static final String LIMIT_ENABLED_KEY = "limitEnabled";
    private boolean limitEnabled = false;
    private static final String AFTER_KEY = "after";
    static final Integer AFTER_DEFAULT_VALUE = 0;
    static final Integer AFTER_MINIMUM_VALUE = null;
    static final Integer AFTER_MAXIMUM_VALUE = null;
    private int after = AFTER_DEFAULT_VALUE;
    private static final String AFTER_ENABLED_KEY = "afterEnabled";
    private boolean afterEnabled = false;
    private static final String BEFORE_KEY = "before";
    static final Integer BEFORE_DEFAULT_VALUE = 0;
    static final Integer BEFORE_MINIMUM_VALUE = null;
    static final Integer BEFORE_MAXIMUM_VALUE = null;
    private int before = BEFORE_DEFAULT_VALUE;
    private static final String BEFORE_ENABLED_KEY = "beforeEnabled";
    private boolean beforeEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"href\":\"rows[0][0]\",\"limit\":\"rows[0][1]\",\"next\":\"rows[0][2]\",\"cursors\":\"rows[0][3]\",\"total\":\"rows[0][4]\",\"items\":\"rows[0][5]\"}}]").addBodyColumn(new DataColumnSpecCreator("Href", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Limit", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Next", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Cursors", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Total", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Items", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetRecentlyPlayedNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addInt(LIMIT_KEY, this.limit);
        settings.addBoolean(LIMIT_ENABLED_KEY, this.limitEnabled);
        settings.addInt(AFTER_KEY, this.after);
        settings.addBoolean(AFTER_ENABLED_KEY, this.afterEnabled);
        settings.addInt(BEFORE_KEY, this.before);
        settings.addBoolean(BEFORE_ENABLED_KEY, this.beforeEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.limit = settings.getInt(LIMIT_KEY, LIMIT_DEFAULT_VALUE.intValue());
        this.limitEnabled = settings.getBoolean(LIMIT_ENABLED_KEY, false);
        this.after = settings.getInt(AFTER_KEY, AFTER_DEFAULT_VALUE.intValue());
        this.afterEnabled = settings.getBoolean(AFTER_ENABLED_KEY, false);
        this.before = settings.getInt(BEFORE_KEY, BEFORE_DEFAULT_VALUE.intValue());
        this.beforeEnabled = settings.getBoolean(BEFORE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    int limit() {
        return this.limit;
    }

    void limit(int value) {
        this.limit = value;
    }

    boolean limitEnabled() {
        return this.limitEnabled;
    }

    void limitEnabled(boolean value) {
        this.limitEnabled = value;
    }

    int after() {
        return this.after;
    }

    void after(int value) {
        this.after = value;
    }

    boolean afterEnabled() {
        return this.afterEnabled;
    }

    void afterEnabled(boolean value) {
        this.afterEnabled = value;
    }

    int before() {
        return this.before;
    }

    void before(int value) {
        this.before = value;
    }

    boolean beforeEnabled() {
        return this.beforeEnabled;
    }

    void beforeEnabled(boolean value) {
        this.beforeEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

