/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getseveralchapters;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetSeveralChaptersNodeSettings {
    private static final String IDS_KEY = "ids";
    private static final String IDS_DEFAULT_VALUE = null;
    private String ids = IDS_DEFAULT_VALUE;
    private static final String MARKET_KEY = "market";
    private static final String MARKET_DEFAULT_VALUE = null;
    private String market = MARKET_DEFAULT_VALUE;
    private static final String MARKET_ENABLED_KEY = "marketEnabled";
    private boolean marketEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"chapters\":{\"*\":{\"audio_preview_url\":\"rows[#2][0]\",\"available_markets\":\"rows[#2][1]\",\"chapter_number\":\"rows[#2][2]\",\"description\":\"rows[#2][3]\",\"html_description\":\"rows[#2][4]\",\"duration_ms\":\"rows[#2][5]\",\"explicit\":\"rows[#2][6]\",\"external_urls\":\"rows[#2][7]\",\"href\":\"rows[#2][8]\",\"id\":\"rows[#2][9]\",\"images\":\"rows[#2][10]\",\"is_playable\":\"rows[#2][11]\",\"languages\":\"rows[#2][12]\",\"name\":\"rows[#2][13]\",\"release_date\":\"rows[#2][14]\",\"release_date_precision\":\"rows[#2][15]\",\"resume_point\":\"rows[#2][16]\",\"type\":\"rows[#2][17]\",\"uri\":\"rows[#2][18]\",\"restrictions\":\"rows[#2][19]\",\"audiobook\":\"rows[#2][20]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Audio Preview Url", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Available Markets", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Chapter Number", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Html Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Duration Ms", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Explicit", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("External Urls", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Href", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Images", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Playable", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Languages", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Release Date", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Release Date Precision", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Resume Point", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Uri", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Restrictions", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Audiobook", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetSeveralChaptersNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(IDS_KEY, this.ids);
        settings.addString(MARKET_KEY, this.market);
        settings.addBoolean(MARKET_ENABLED_KEY, this.marketEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.ids = settings.getString(IDS_KEY, IDS_DEFAULT_VALUE);
        this.market = settings.getString(MARKET_KEY, MARKET_DEFAULT_VALUE);
        this.marketEnabled = settings.getBoolean(MARKET_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.ids == null || this.ids.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cIds\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String ids() {
        return this.ids;
    }

    void ids(String value) {
        this.ids = value;
    }

    String market() {
        return this.market;
    }

    void market(String value) {
        this.market = value;
    }

    boolean marketEnabled() {
        return this.marketEnabled;
    }

    void marketEnabled(boolean value) {
        this.marketEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

