/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.seektopositionincurrentlyplayingtrack;

import com.nodepit.nodes.spotify.v1.LabelButton;
import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.operation.seektopositionincurrentlyplayingtrack.SeekToPositionInCurrentlyPlayingTrackNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class SeekToPositionInCurrentlyPlayingTrackNodeDialog
extends NodeDialogPane {
    private final SeekToPositionInCurrentlyPlayingTrackNodeSettings nodeSettings = new SeekToPositionInCurrentlyPlayingTrackNodeSettings();
    private JSpinner positionMs;
    private JTextField deviceId;
    private JCheckBox deviceIdEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    SeekToPositionInCurrentlyPlayingTrackNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Position Ms:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.positionMs = new JSpinner(new SpinnerNumberModel(SeekToPositionInCurrentlyPlayingTrackNodeSettings.POSITION_MS_DEFAULT_VALUE, SeekToPositionInCurrentlyPlayingTrackNodeSettings.POSITION_MS_MINIMUM_VALUE, SeekToPositionInCurrentlyPlayingTrackNodeSettings.POSITION_MS_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.positionMs, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Device Id:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.deviceIdEnabled = new JCheckBox();
        this.deviceIdEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.deviceIdEnabled.setSelected(!this.deviceIdEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.deviceIdEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.deviceId = new JTextField(30);
        panel.add((Component)this.deviceId, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(SeekToPositionInCurrentlyPlayingTrackNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.deviceId.setEnabled(this.deviceIdEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.positionMs((Integer)this.positionMs.getValue());
        this.nodeSettings.deviceId(this.deviceId.getText());
        this.nodeSettings.deviceIdEnabled(this.deviceIdEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.positionMs.setValue(this.nodeSettings.positionMs());
        this.deviceId.setText(this.nodeSettings.deviceId());
        this.deviceIdEnabled.setSelected(this.nodeSettings.deviceIdEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

