/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.auth.oauth20;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.nodepit.nodes.spotify.v1.auth.oauth20.Oauth20NodeSettings;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Callback;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class Oauth20NodeDialog
extends NodeDialogPane {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(Oauth20NodeDialog.class);
    private final Oauth20NodeSettings nodeSettings = new Oauth20NodeSettings();
    private static Server server;
    private JTextField clientId;
    private JPasswordField clientSecret;
    private JLabel statusLabel;
    private JButton requestTokenButton;
    private JButton deleteTokenButton;
    private JList<String> scopesList;

    Oauth20NodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new JLabel("Client ID:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.clientId = new JTextField(30);
        panel.add((Component)this.clientId, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new JLabel("Client Secret:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.clientSecret = new JPasswordField(30);
        panel.add((Component)this.clientSecret, c);
        ++c.gridy;
        panel.add((Component)new JLabel(""), c);
        ++c.gridy;
        panel.add((Component)new JLabel(""), c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new JLabel("Scopes:"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.scopesList = new JList<String>(Oauth20NodeSettings.SCOPES);
        this.scopesList.setVisibleRowCount(5);
        panel.add((Component)new JScrollPane(this.scopesList), c);
        ++c.gridy;
        c.weighty = 0.0;
        panel.add((Component)new JLabel(""), c);
        ++c.gridy;
        panel.add((Component)new JLabel(""), c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        c.anchor = 13;
        this.statusLabel = new JLabel("Click the button to request an access token.");
        this.statusLabel.setHorizontalAlignment(0);
        panel.add((Component)this.statusLabel, c);
        ++c.gridy;
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.requestTokenButton = new JButton("Authorize Access");
        this.requestTokenButton.addActionListener(e -> this.requestToken());
        buttonsPanel.add(this.requestTokenButton);
        this.deleteTokenButton = new JButton("Clear Token");
        this.deleteTokenButton.addActionListener(e -> this.clearToken());
        buttonsPanel.add(this.deleteTokenButton);
        panel.add((Component)buttonsPanel, c);
        return panel;
    }

    private void updateModel() {
        this.nodeSettings.clientId(this.clientId.getText());
        this.nodeSettings.clientSecret(new String(this.clientSecret.getPassword()));
        this.nodeSettings.scope((String[])this.scopesList.getSelectedValuesList().toArray(String[]::new));
    }

    private void requestToken() {
        OAuth20Service oauthService;
        this.updateModel();
        try {
            this.nodeSettings.validateSettingsForTokenRequest();
        }
        catch (InvalidSettingsException e) {
            JOptionPane.showMessageDialog(this.getPanel(), e.getMessage(), null, 0);
            return;
        }
        try {
            String scopeValue = Stream.of(this.nodeSettings.scope(), Oauth20NodeSettings.PERMANENT_SCOPES).flatMap(stringArray -> Stream.of(stringArray)).collect(Collectors.joining(" "));
            oauthService = new ServiceBuilder(this.nodeSettings.clientId()).apiSecret(this.nodeSettings.clientSecret()).callback("http://localhost:54321").defaultScope(scopeValue).build((DefaultApi20)new OAuthAPI());
        }
        catch (Exception e) {
            String msg = "<html><body><p style='width:300px'>" + StringEscapeUtils.escapeHtml4((String)e.getMessage()) + "</p></body></html>";
            JOptionPane.showMessageDialog(this.getPanel(), msg, null, 0);
            return;
        }
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    Oauth20NodeDialog.this.startServerIfNotYetRunning(oauthService);
                }
                catch (Exception e) {
                    Oauth20NodeDialog.this.updateStatus("Could not start HTTP server on port 54321: " + e.getMessage(), e);
                    return null;
                }
                Desktop.getDesktop().browse(new URI(oauthService.getAuthorizationUrl()));
                Oauth20NodeDialog.this.updateStatus("Waiting for authorization \u2013 please check your browser.", null);
                return null;
            }
        }.execute();
    }

    private void clearToken() {
        this.nodeSettings.accessToken(null);
        this.nodeSettings.expiresAt(-1L);
        this.nodeSettings.refreshToken(null);
        this.updateControlsAndMessageLabel();
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.clientId.setText(this.nodeSettings.clientId());
        this.clientSecret.setText(this.nodeSettings.clientSecret());
        int[] selectedIndices = new int[this.nodeSettings.scope().length];
        String[] scopes = this.nodeSettings.scope();
        int i = 0;
        while (i < scopes.length) {
            selectedIndices[i] = Arrays.asList(Oauth20NodeSettings.SCOPES).indexOf(scopes[i]);
            ++i;
        }
        this.scopesList.setSelectedIndices(selectedIndices);
        this.updateControlsAndMessageLabel();
    }

    private void updateControlsAndMessageLabel() {
        boolean hasToken = this.nodeSettings.refreshToken() != null && !this.nodeSettings.refreshToken().isEmpty();
        this.deleteTokenButton.setEnabled(hasToken);
        this.requestTokenButton.setEnabled(!hasToken);
        this.clientId.setEnabled(!hasToken);
        this.clientSecret.setEnabled(!hasToken);
        this.scopesList.setEnabled(!hasToken);
        String msg = hasToken ? "Authenticated successfully" : "Click the button to request a refresh token.";
        this.statusLabel.setText(msg);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.updateModel();
        this.nodeSettings.saveSettingsTo(settings);
    }

    public void onClose() {
        this.stopServerIfRunning();
    }

    private void startServerIfNotYetRunning(final OAuth20Service oauthService) throws Exception {
        if (server != null && server.isRunning()) {
            LOGGER.debug((Object)"Server is already running");
            return;
        }
        server = new Server(54321);
        server.setHandler((Handler)new Handler.Abstract(){

            public boolean handle(Request request, Response response, Callback callback) throws Exception {
                LOGGER.debugWithFormat(request.toString(), new Object[0]);
                if (request.getHttpURI().getPath().equals("/") && request.getHttpURI().getQuery().startsWith("code=")) {
                    String code = request.getHttpURI().getQuery().replaceAll("^code=", "");
                    code = code.replaceAll("&.*$", "");
                    Oauth20NodeDialog.this.receivedCode(code, oauthService);
                    response.setStatus(200);
                    response.getHeaders().put(HttpHeader.CONTENT_TYPE, "text/html;charset=utf-8");
                    Content.Sink.write((Content.Sink)response, (boolean)true, (String)Oauth20NodeDialog.addLogoIfExists(Oauth20NodeDialog.getAccessGrantedHtml()), (Callback)callback);
                } else if (!request.getHttpURI().getPath().equals("/") || !request.getHttpURI().getQuery().contains("error=")) {
                    response.setStatus(404);
                }
                return true;
            }
        });
        this.updateStatus("Starting HTTP server on 54321", null);
        server.start();
    }

    private void stopServerIfRunning() {
        if (server != null && server.isRunning()) {
            try {
                this.updateStatus("Stopping running server", null);
                server.stop();
                server = null;
            }
            catch (Exception e) {
                this.updateStatus("Error: Could not stop running server", e);
            }
        }
    }

    private void updateStatus(String message, Exception ex) {
        this.statusLabel.setText(message);
        if (ex != null) {
            LOGGER.error((Object)message, (Throwable)ex);
        } else {
            LOGGER.info((Object)message);
        }
    }

    private void receivedCode(String code, OAuth20Service oauthService) {
        this.updateStatus("Authorization code: " + code, null);
        try {
            OAuth2AccessToken accessTokenResult = oauthService.getAccessToken(code);
            String refreshToken = accessTokenResult.getRefreshToken();
            this.nodeSettings.accessToken(accessTokenResult.getAccessToken());
            this.nodeSettings.expiresAt(System.currentTimeMillis() + (long)(accessTokenResult.getExpiresIn() * 1000));
            this.nodeSettings.refreshToken(refreshToken);
            this.updateControlsAndMessageLabel();
        }
        catch (Exception e) {
            this.updateStatus("Could not get refresh token: " + e.getMessage(), e);
        }
    }

    private static String getAccessGrantedHtml() throws IOException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Oauth20NodeDialog.class.getResourceAsStream("AccessGranted.html"), StandardCharsets.UTF_8));){
            return reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String addLogoIfExists(String html) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL("platform:/plugin/com.nodepit.nodes.spotify.v1.plugin/resources/product.svg").openConnection().getInputStream()));){
                String svgFile = reader.lines().collect(Collectors.joining());
                Pattern pattern = Pattern.compile("<svg.*<\\/svg>");
                Matcher matcher = pattern.matcher(svgFile);
                if (matcher.find()) {
                    String svgElement = matcher.group(0);
                    html = html.replaceAll("<!--logo-placeholder-->", svgElement);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return html;
    }

    static final class OAuthAPI
    extends DefaultApi20 {
        OAuthAPI() {
        }

        protected String getAuthorizationBaseUrl() {
            return "https://accounts.spotify.com/authorize";
        }

        public String getAccessTokenEndpoint() {
            return "https://accounts.spotify.com/api/token";
        }
    }
}

