/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.auth.oauth20;

import java.util.ArrayList;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class Oauth20NodeSettings {
    static final String AUTHORIZATION_BASE_URL = "https://accounts.spotify.com/authorize";
    static final String ACCESS_TOKEN_ENDPOINT = "https://accounts.spotify.com/api/token";
    static final int PORT = 54321;
    static final String REDIRECT_URI = "http://localhost:54321";
    static final String[] PERMANENT_SCOPES = new String[0];
    static final String[] SCOPES = new String[]{"app-remote-control", "playlist-read-private", "playlist-read-collaborative", "playlist-modify-public", "playlist-modify-private", "user-library-read", "user-library-modify", "user-read-private", "user-read-email", "user-follow-read", "user-follow-modify", "user-top-read", "user-read-playback-position", "user-read-playback-state", "user-read-recently-played", "user-read-currently-playing", "user-modify-playback-state", "ugc-image-upload", "streaming"};
    private static final String CLIENT_ID_KEY = "clientId";
    private static final String CLIENT_SECRET_KEY = "clientSecret";
    private String clientId = null;
    private String clientSecret = null;
    private static final String SCOPES_KEY = "scope";
    private String[] scope = new String[0];
    private static final String ACCESS_TOKEN_KEY = "accessToken";
    private String accessToken = null;
    private static final String EXPIRES_AT_KEY = "expiresAt";
    private long expiresAt = -1L;
    private static final String REFRESH_TOKEN_KEY = "refreshToken";
    private String refreshToken = null;

    Oauth20NodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(CLIENT_ID_KEY, this.clientId);
        settings.addString(CLIENT_SECRET_KEY, this.clientSecret);
        settings.addStringArray(SCOPES_KEY, this.scope);
        settings.addString(ACCESS_TOKEN_KEY, this.accessToken);
        settings.addLong(EXPIRES_AT_KEY, this.expiresAt);
        settings.addString(REFRESH_TOKEN_KEY, this.refreshToken);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.clientId = settings.getString(CLIENT_ID_KEY, null);
        this.clientSecret = settings.getString(CLIENT_SECRET_KEY, null);
        this.scope = settings.getStringArray(SCOPES_KEY, new String[0]);
        this.accessToken = settings.getString(ACCESS_TOKEN_KEY, null);
        this.expiresAt = settings.getLong(EXPIRES_AT_KEY, -1L);
        this.refreshToken = settings.getString(REFRESH_TOKEN_KEY, null);
    }

    String clientId() {
        return this.clientId;
    }

    void clientId(String clientId) {
        this.clientId = clientId;
    }

    String clientSecret() {
        return this.clientSecret;
    }

    void clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    String[] scope() {
        return this.scope;
    }

    void scope(String[] scope) {
        this.scope = scope;
    }

    String accessToken() {
        return this.accessToken;
    }

    void accessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    long expiresAt() {
        return this.expiresAt;
    }

    void expiresAt(long expiresAt) {
        this.expiresAt = expiresAt;
    }

    String refreshToken() {
        return this.refreshToken;
    }

    void refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    void validateSettingsForTokenRequest() throws InvalidSettingsException {
        ArrayList<String> missingInput = new ArrayList<String>();
        if (this.clientId == null || this.clientId.isEmpty()) {
            missingInput.add("Client ID");
        }
        if (this.clientSecret == null || this.clientSecret.isEmpty()) {
            missingInput.add("Client Secret");
        }
        if (this.scope == null || this.scope.length == 0) {
            missingInput.add("Scope(s)");
        }
        if (!missingInput.isEmpty()) {
            throw new InvalidSettingsException("The following input for authorizing is missing:\n" + String.join((CharSequence)", ", missingInput));
        }
    }
}

