/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getacategory;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetACategoryNodeSettings {
    private static final String CATEGORY_ID_KEY = "categoryId";
    private static final String CATEGORY_ID_DEFAULT_VALUE = null;
    private String categoryId = CATEGORY_ID_DEFAULT_VALUE;
    private static final String LOCALE_KEY = "locale";
    private static final String LOCALE_DEFAULT_VALUE = null;
    private String locale = LOCALE_DEFAULT_VALUE;
    private static final String LOCALE_ENABLED_KEY = "localeEnabled";
    private boolean localeEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"href\":\"rows[0][0]\",\"icons\":\"rows[0][1]\",\"id\":\"rows[0][2]\",\"name\":\"rows[0][3]\"}}]").addBodyColumn(new DataColumnSpecCreator("Href", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Icons", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetACategoryNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(CATEGORY_ID_KEY, this.categoryId);
        settings.addString(LOCALE_KEY, this.locale);
        settings.addBoolean(LOCALE_ENABLED_KEY, this.localeEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.categoryId = settings.getString(CATEGORY_ID_KEY, CATEGORY_ID_DEFAULT_VALUE);
        this.locale = settings.getString(LOCALE_KEY, LOCALE_DEFAULT_VALUE);
        this.localeEnabled = settings.getBoolean(LOCALE_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.categoryId == null || this.categoryId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cCategory Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String categoryId() {
        return this.categoryId;
    }

    void categoryId(String value) {
        this.categoryId = value;
    }

    String locale() {
        return this.locale;
    }

    void locale(String value) {
        this.locale = value;
    }

    boolean localeEnabled() {
        return this.localeEnabled;
    }

    void localeEnabled(boolean value) {
        this.localeEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

