/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getanalbum;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetAnAlbumNodeSettings {
    private static final String ID_KEY = "id";
    private static final String ID_DEFAULT_VALUE = null;
    private String id = ID_DEFAULT_VALUE;
    private static final String MARKET_KEY = "market";
    private static final String MARKET_DEFAULT_VALUE = null;
    private String market = MARKET_DEFAULT_VALUE;
    private static final String MARKET_ENABLED_KEY = "marketEnabled";
    private boolean marketEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"album_type\":\"rows[0][0]\",\"total_tracks\":\"rows[0][1]\",\"available_markets\":\"rows[0][2]\",\"external_urls\":\"rows[0][3]\",\"href\":\"rows[0][4]\",\"id\":\"rows[0][5]\",\"images\":\"rows[0][6]\",\"name\":\"rows[0][7]\",\"release_date\":\"rows[0][8]\",\"release_date_precision\":\"rows[0][9]\",\"restrictions\":\"rows[0][10]\",\"type\":\"rows[0][11]\",\"uri\":\"rows[0][12]\",\"artists\":\"rows[0][13]\",\"tracks\":\"rows[0][14]\",\"copyrights\":\"rows[0][15]\",\"external_ids\":\"rows[0][16]\",\"genres\":\"rows[0][17]\",\"label\":\"rows[0][18]\",\"popularity\":\"rows[0][19]\"}}]").addBodyColumn(new DataColumnSpecCreator("Album Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Total Tracks", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Available Markets", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("External Urls", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Href", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Images", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Release Date", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Release Date Precision", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Restrictions", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Uri", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Artists", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tracks", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Copyrights", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("External Ids", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Genres", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Label", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Popularity", LongCell.LongCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetAnAlbumNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ID_KEY, this.id);
        settings.addString(MARKET_KEY, this.market);
        settings.addBoolean(MARKET_ENABLED_KEY, this.marketEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.id = settings.getString(ID_KEY, ID_DEFAULT_VALUE);
        this.market = settings.getString(MARKET_KEY, MARKET_DEFAULT_VALUE);
        this.marketEnabled = settings.getBoolean(MARKET_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cId\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String id() {
        return this.id;
    }

    void id(String value) {
        this.id = value;
    }

    String market() {
        return this.market;
    }

    void market(String value) {
        this.market = value;
    }

    boolean marketEnabled() {
        return this.marketEnabled;
    }

    void marketEnabled(boolean value) {
        this.marketEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

