/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getaudioanalysis;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetAudioAnalysisNodeSettings {
    private static final String ID_KEY = "id";
    private static final String ID_DEFAULT_VALUE = null;
    private String id = ID_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"meta\":\"rows[0][0]\",\"track\":\"rows[0][1]\",\"bars\":\"rows[0][2]\",\"beats\":\"rows[0][3]\",\"sections\":\"rows[0][4]\",\"segments\":\"rows[0][5]\",\"tatums\":\"rows[0][6]\"}}]").addBodyColumn(new DataColumnSpecCreator("Meta", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Track", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Bars", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Beats", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Sections", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Segments", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tatums", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetAudioAnalysisNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(ID_KEY, this.id);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.id = settings.getString(ID_KEY, ID_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cId\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String id() {
        return this.id;
    }

    void id(String value) {
        this.id = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

