/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getfollowed;

import com.nodepit.nodes.spotify.v1.LabelButton;
import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.operation.getfollowed.GetFollowedNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class GetFollowedNodeDialog
extends NodeDialogPane {
    private final GetFollowedNodeSettings nodeSettings = new GetFollowedNodeSettings();
    private JComboBox<String> type;
    private JTextField after;
    private JCheckBox afterEnabled;
    private JSpinner limit;
    private JCheckBox limitEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    GetFollowedNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Type:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.type = new JComboBox<String>(GetFollowedNodeSettings.TYPE_VALUES);
        panel.add(this.type, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("After:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.afterEnabled = new JCheckBox();
        this.afterEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.afterEnabled.setSelected(!this.afterEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.afterEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.after = new JTextField(30);
        panel.add((Component)this.after, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Limit:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.limitEnabled = new JCheckBox();
        this.limitEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.limitEnabled.setSelected(!this.limitEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.limitEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.limit = new JSpinner(new SpinnerNumberModel(GetFollowedNodeSettings.LIMIT_DEFAULT_VALUE, GetFollowedNodeSettings.LIMIT_MINIMUM_VALUE, GetFollowedNodeSettings.LIMIT_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.limit, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(GetFollowedNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.after.setEnabled(this.afterEnabled.isSelected());
        this.limit.setEnabled(this.limitEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.type((String)this.type.getSelectedItem());
        this.nodeSettings.after(this.after.getText());
        this.nodeSettings.afterEnabled(this.afterEnabled.isSelected());
        this.nodeSettings.limit((Integer)this.limit.getValue());
        this.nodeSettings.limitEnabled(this.limitEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.type.setSelectedItem(this.nodeSettings.type());
        this.after.setText(this.nodeSettings.after());
        this.afterEnabled.setSelected(this.nodeSettings.afterEnabled());
        this.limit.setValue(this.nodeSettings.limit());
        this.limitEnabled.setSelected(this.nodeSettings.limitEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

