/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getinformationabouttheuserscurrentplayback;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetInformationAboutTheUsersCurrentPlaybackNodeSettings {
    private static final String MARKET_KEY = "market";
    private static final String MARKET_DEFAULT_VALUE = null;
    private String market = MARKET_DEFAULT_VALUE;
    private static final String MARKET_ENABLED_KEY = "marketEnabled";
    private boolean marketEnabled = false;
    private static final String ADDITIONAL_TYPES_KEY = "additionalTypes";
    private static final String ADDITIONAL_TYPES_DEFAULT_VALUE = null;
    private String additionalTypes = ADDITIONAL_TYPES_DEFAULT_VALUE;
    private static final String ADDITIONAL_TYPES_ENABLED_KEY = "additionalTypesEnabled";
    private boolean additionalTypesEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"device\":\"rows[0][0]\",\"repeat_state\":\"rows[0][1]\",\"shuffle_state\":\"rows[0][2]\",\"context\":\"rows[0][3]\",\"timestamp\":\"rows[0][4]\",\"progress_ms\":\"rows[0][5]\",\"is_playing\":\"rows[0][6]\",\"item\":\"rows[0][7]\",\"currently_playing_type\":\"rows[0][8]\",\"actions\":\"rows[0][9]\"}}]").addBodyColumn(new DataColumnSpecCreator("Device", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Repeat State", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Shuffle State", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Context", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Timestamp", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Progress Ms", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Is Playing", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Item", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Currently Playing Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Actions", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetInformationAboutTheUsersCurrentPlaybackNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(MARKET_KEY, this.market);
        settings.addBoolean(MARKET_ENABLED_KEY, this.marketEnabled);
        settings.addString(ADDITIONAL_TYPES_KEY, this.additionalTypes);
        settings.addBoolean(ADDITIONAL_TYPES_ENABLED_KEY, this.additionalTypesEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.market = settings.getString(MARKET_KEY, MARKET_DEFAULT_VALUE);
        this.marketEnabled = settings.getBoolean(MARKET_ENABLED_KEY, false);
        this.additionalTypes = settings.getString(ADDITIONAL_TYPES_KEY, ADDITIONAL_TYPES_DEFAULT_VALUE);
        this.additionalTypesEnabled = settings.getBoolean(ADDITIONAL_TYPES_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String market() {
        return this.market;
    }

    void market(String value) {
        this.market = value;
    }

    boolean marketEnabled() {
        return this.marketEnabled;
    }

    void marketEnabled(boolean value) {
        this.marketEnabled = value;
    }

    String additionalTypes() {
        return this.additionalTypes;
    }

    void additionalTypes(String value) {
        this.additionalTypes = value;
    }

    boolean additionalTypesEnabled() {
        return this.additionalTypesEnabled;
    }

    void additionalTypesEnabled(boolean value) {
        this.additionalTypesEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

