/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getplaylist;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetPlaylistNodeSettings {
    private static final String PLAYLIST_ID_KEY = "playlistId";
    private static final String PLAYLIST_ID_DEFAULT_VALUE = null;
    private String playlistId = PLAYLIST_ID_DEFAULT_VALUE;
    private static final String MARKET_KEY = "market";
    private static final String MARKET_DEFAULT_VALUE = null;
    private String market = MARKET_DEFAULT_VALUE;
    private static final String MARKET_ENABLED_KEY = "marketEnabled";
    private boolean marketEnabled = false;
    private static final String FIELDS_KEY = "fields";
    private static final String FIELDS_DEFAULT_VALUE = null;
    private String fields = FIELDS_DEFAULT_VALUE;
    private static final String FIELDS_ENABLED_KEY = "fieldsEnabled";
    private boolean fieldsEnabled = false;
    private static final String ADDITIONAL_TYPES_KEY = "additionalTypes";
    private static final String ADDITIONAL_TYPES_DEFAULT_VALUE = null;
    private String additionalTypes = ADDITIONAL_TYPES_DEFAULT_VALUE;
    private static final String ADDITIONAL_TYPES_ENABLED_KEY = "additionalTypesEnabled";
    private boolean additionalTypesEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"collaborative\":\"rows[0][0]\",\"description\":\"rows[0][1]\",\"external_urls\":\"rows[0][2]\",\"followers\":\"rows[0][3]\",\"href\":\"rows[0][4]\",\"id\":\"rows[0][5]\",\"images\":\"rows[0][6]\",\"name\":\"rows[0][7]\",\"owner\":\"rows[0][8]\",\"public\":\"rows[0][9]\",\"snapshot_id\":\"rows[0][10]\",\"tracks\":\"rows[0][11]\",\"type\":\"rows[0][12]\",\"uri\":\"rows[0][13]\"}}]").addBodyColumn(new DataColumnSpecCreator("Collaborative", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("External Urls", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Followers", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Href", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Images", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Owner", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Public", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Snapshot Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tracks", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Uri", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetPlaylistNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(PLAYLIST_ID_KEY, this.playlistId);
        settings.addString(MARKET_KEY, this.market);
        settings.addBoolean(MARKET_ENABLED_KEY, this.marketEnabled);
        settings.addString(FIELDS_KEY, this.fields);
        settings.addBoolean(FIELDS_ENABLED_KEY, this.fieldsEnabled);
        settings.addString(ADDITIONAL_TYPES_KEY, this.additionalTypes);
        settings.addBoolean(ADDITIONAL_TYPES_ENABLED_KEY, this.additionalTypesEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.playlistId = settings.getString(PLAYLIST_ID_KEY, PLAYLIST_ID_DEFAULT_VALUE);
        this.market = settings.getString(MARKET_KEY, MARKET_DEFAULT_VALUE);
        this.marketEnabled = settings.getBoolean(MARKET_ENABLED_KEY, false);
        this.fields = settings.getString(FIELDS_KEY, FIELDS_DEFAULT_VALUE);
        this.fieldsEnabled = settings.getBoolean(FIELDS_ENABLED_KEY, false);
        this.additionalTypes = settings.getString(ADDITIONAL_TYPES_KEY, ADDITIONAL_TYPES_DEFAULT_VALUE);
        this.additionalTypesEnabled = settings.getBoolean(ADDITIONAL_TYPES_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.playlistId == null || this.playlistId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cPlaylist Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String playlistId() {
        return this.playlistId;
    }

    void playlistId(String value) {
        this.playlistId = value;
    }

    String market() {
        return this.market;
    }

    void market(String value) {
        this.market = value;
    }

    boolean marketEnabled() {
        return this.marketEnabled;
    }

    void marketEnabled(boolean value) {
        this.marketEnabled = value;
    }

    String fields() {
        return this.fields;
    }

    void fields(String value) {
        this.fields = value;
    }

    boolean fieldsEnabled() {
        return this.fieldsEnabled;
    }

    void fieldsEnabled(boolean value) {
        this.fieldsEnabled = value;
    }

    String additionalTypes() {
        return this.additionalTypes;
    }

    void additionalTypes(String value) {
        this.additionalTypes = value;
    }

    boolean additionalTypesEnabled() {
        return this.additionalTypesEnabled;
    }

    void additionalTypesEnabled(boolean value) {
        this.additionalTypesEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

