/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getrecommendations;

import com.nodepit.nodes.spotify.v1.operation.getrecommendations.GetRecommendationsNodeSettings;
import com.nodepit.nodes.spotify.v1.port.ConfigPortObjectSpec;
import java.io.File;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

class GetRecommendationsNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(GetRecommendationsNodeModel.class);
    private final GetRecommendationsNodeSettings nodeSettings = new GetRecommendationsNodeSettings();

    protected GetRecommendationsNodeModel(PortType[] inPorts, PortType[] outPorts) {
        super(inPorts, outPorts);
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        ConfigPortObjectSpec configPortObjectSpec = this.getNrInPorts() == 0 ? ConfigPortObjectSpec.DEFAULT : (ConfigPortObjectSpec)inObjects[0].getSpec();
        String serverUrl = configPortObjectSpec.getUrl();
        String path = "/recommendations";
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)(String.valueOf(serverUrl) + path)).newBuilder();
        if (this.nodeSettings.limitEnabled()) {
            urlBuilder.addQueryParameter("limit", String.valueOf(this.nodeSettings.limit()));
        }
        if (this.nodeSettings.marketEnabled()) {
            urlBuilder.addQueryParameter("market", String.valueOf(this.nodeSettings.market()));
        }
        if (this.nodeSettings.seedArtistsEnabled()) {
            urlBuilder.addQueryParameter("seed_artists", String.valueOf(this.nodeSettings.seedArtists()));
        }
        if (this.nodeSettings.seedGenresEnabled()) {
            urlBuilder.addQueryParameter("seed_genres", String.valueOf(this.nodeSettings.seedGenres()));
        }
        if (this.nodeSettings.seedTracksEnabled()) {
            urlBuilder.addQueryParameter("seed_tracks", String.valueOf(this.nodeSettings.seedTracks()));
        }
        if (this.nodeSettings.minAcousticnessEnabled()) {
            urlBuilder.addQueryParameter("min_acousticness", String.valueOf(this.nodeSettings.minAcousticness()));
        }
        if (this.nodeSettings.maxAcousticnessEnabled()) {
            urlBuilder.addQueryParameter("max_acousticness", String.valueOf(this.nodeSettings.maxAcousticness()));
        }
        if (this.nodeSettings.targetAcousticnessEnabled()) {
            urlBuilder.addQueryParameter("target_acousticness", String.valueOf(this.nodeSettings.targetAcousticness()));
        }
        if (this.nodeSettings.minDanceabilityEnabled()) {
            urlBuilder.addQueryParameter("min_danceability", String.valueOf(this.nodeSettings.minDanceability()));
        }
        if (this.nodeSettings.maxDanceabilityEnabled()) {
            urlBuilder.addQueryParameter("max_danceability", String.valueOf(this.nodeSettings.maxDanceability()));
        }
        if (this.nodeSettings.targetDanceabilityEnabled()) {
            urlBuilder.addQueryParameter("target_danceability", String.valueOf(this.nodeSettings.targetDanceability()));
        }
        if (this.nodeSettings.minDurationMsEnabled()) {
            urlBuilder.addQueryParameter("min_duration_ms", String.valueOf(this.nodeSettings.minDurationMs()));
        }
        if (this.nodeSettings.maxDurationMsEnabled()) {
            urlBuilder.addQueryParameter("max_duration_ms", String.valueOf(this.nodeSettings.maxDurationMs()));
        }
        if (this.nodeSettings.targetDurationMsEnabled()) {
            urlBuilder.addQueryParameter("target_duration_ms", String.valueOf(this.nodeSettings.targetDurationMs()));
        }
        if (this.nodeSettings.minEnergyEnabled()) {
            urlBuilder.addQueryParameter("min_energy", String.valueOf(this.nodeSettings.minEnergy()));
        }
        if (this.nodeSettings.maxEnergyEnabled()) {
            urlBuilder.addQueryParameter("max_energy", String.valueOf(this.nodeSettings.maxEnergy()));
        }
        if (this.nodeSettings.targetEnergyEnabled()) {
            urlBuilder.addQueryParameter("target_energy", String.valueOf(this.nodeSettings.targetEnergy()));
        }
        if (this.nodeSettings.minInstrumentalnessEnabled()) {
            urlBuilder.addQueryParameter("min_instrumentalness", String.valueOf(this.nodeSettings.minInstrumentalness()));
        }
        if (this.nodeSettings.maxInstrumentalnessEnabled()) {
            urlBuilder.addQueryParameter("max_instrumentalness", String.valueOf(this.nodeSettings.maxInstrumentalness()));
        }
        if (this.nodeSettings.targetInstrumentalnessEnabled()) {
            urlBuilder.addQueryParameter("target_instrumentalness", String.valueOf(this.nodeSettings.targetInstrumentalness()));
        }
        if (this.nodeSettings.minKeyEnabled()) {
            urlBuilder.addQueryParameter("min_key", String.valueOf(this.nodeSettings.minKey()));
        }
        if (this.nodeSettings.maxKeyEnabled()) {
            urlBuilder.addQueryParameter("max_key", String.valueOf(this.nodeSettings.maxKey()));
        }
        if (this.nodeSettings.targetKeyEnabled()) {
            urlBuilder.addQueryParameter("target_key", String.valueOf(this.nodeSettings.targetKey()));
        }
        if (this.nodeSettings.minLivenessEnabled()) {
            urlBuilder.addQueryParameter("min_liveness", String.valueOf(this.nodeSettings.minLiveness()));
        }
        if (this.nodeSettings.maxLivenessEnabled()) {
            urlBuilder.addQueryParameter("max_liveness", String.valueOf(this.nodeSettings.maxLiveness()));
        }
        if (this.nodeSettings.targetLivenessEnabled()) {
            urlBuilder.addQueryParameter("target_liveness", String.valueOf(this.nodeSettings.targetLiveness()));
        }
        if (this.nodeSettings.minLoudnessEnabled()) {
            urlBuilder.addQueryParameter("min_loudness", String.valueOf(this.nodeSettings.minLoudness()));
        }
        if (this.nodeSettings.maxLoudnessEnabled()) {
            urlBuilder.addQueryParameter("max_loudness", String.valueOf(this.nodeSettings.maxLoudness()));
        }
        if (this.nodeSettings.targetLoudnessEnabled()) {
            urlBuilder.addQueryParameter("target_loudness", String.valueOf(this.nodeSettings.targetLoudness()));
        }
        if (this.nodeSettings.minModeEnabled()) {
            urlBuilder.addQueryParameter("min_mode", String.valueOf(this.nodeSettings.minMode()));
        }
        if (this.nodeSettings.maxModeEnabled()) {
            urlBuilder.addQueryParameter("max_mode", String.valueOf(this.nodeSettings.maxMode()));
        }
        if (this.nodeSettings.targetModeEnabled()) {
            urlBuilder.addQueryParameter("target_mode", String.valueOf(this.nodeSettings.targetMode()));
        }
        if (this.nodeSettings.minPopularityEnabled()) {
            urlBuilder.addQueryParameter("min_popularity", String.valueOf(this.nodeSettings.minPopularity()));
        }
        if (this.nodeSettings.maxPopularityEnabled()) {
            urlBuilder.addQueryParameter("max_popularity", String.valueOf(this.nodeSettings.maxPopularity()));
        }
        if (this.nodeSettings.targetPopularityEnabled()) {
            urlBuilder.addQueryParameter("target_popularity", String.valueOf(this.nodeSettings.targetPopularity()));
        }
        if (this.nodeSettings.minSpeechinessEnabled()) {
            urlBuilder.addQueryParameter("min_speechiness", String.valueOf(this.nodeSettings.minSpeechiness()));
        }
        if (this.nodeSettings.maxSpeechinessEnabled()) {
            urlBuilder.addQueryParameter("max_speechiness", String.valueOf(this.nodeSettings.maxSpeechiness()));
        }
        if (this.nodeSettings.targetSpeechinessEnabled()) {
            urlBuilder.addQueryParameter("target_speechiness", String.valueOf(this.nodeSettings.targetSpeechiness()));
        }
        if (this.nodeSettings.minTempoEnabled()) {
            urlBuilder.addQueryParameter("min_tempo", String.valueOf(this.nodeSettings.minTempo()));
        }
        if (this.nodeSettings.maxTempoEnabled()) {
            urlBuilder.addQueryParameter("max_tempo", String.valueOf(this.nodeSettings.maxTempo()));
        }
        if (this.nodeSettings.targetTempoEnabled()) {
            urlBuilder.addQueryParameter("target_tempo", String.valueOf(this.nodeSettings.targetTempo()));
        }
        if (this.nodeSettings.minTimeSignatureEnabled()) {
            urlBuilder.addQueryParameter("min_time_signature", String.valueOf(this.nodeSettings.minTimeSignature()));
        }
        if (this.nodeSettings.maxTimeSignatureEnabled()) {
            urlBuilder.addQueryParameter("max_time_signature", String.valueOf(this.nodeSettings.maxTimeSignature()));
        }
        if (this.nodeSettings.targetTimeSignatureEnabled()) {
            urlBuilder.addQueryParameter("target_time_signature", String.valueOf(this.nodeSettings.targetTimeSignature()));
        }
        if (this.nodeSettings.minValenceEnabled()) {
            urlBuilder.addQueryParameter("min_valence", String.valueOf(this.nodeSettings.minValence()));
        }
        if (this.nodeSettings.maxValenceEnabled()) {
            urlBuilder.addQueryParameter("max_valence", String.valueOf(this.nodeSettings.maxValence()));
        }
        if (this.nodeSettings.targetValenceEnabled()) {
            urlBuilder.addQueryParameter("target_valence", String.valueOf(this.nodeSettings.targetValence()));
        }
        HttpUrl url = urlBuilder.build();
        RequestBody requestBody = null;
        OkHttpClient.Builder clientBuilder = new OkHttpClient().newBuilder();
        configPortObjectSpec.addInterceptors(clientBuilder);
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(message -> LOGGER.debug((Object)message));
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        clientBuilder.addNetworkInterceptor((Interceptor)loggingInterceptor);
        OkHttpClient client = clientBuilder.build();
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        exec.setProgress("Sending request");
        requestBuilder.method("GET", requestBody);
        requestBuilder.header("accept", this.getResponseType());
        Request request = requestBuilder.build();
        Call call = client.newCall(request);
        exec.setProgress("Receiving response");
        Response response = call.execute();
        if (!response.isSuccessful()) {
            String message2 = "Encountered HTTP status " + response.code();
            String bodyString = response.body().string();
            if (bodyString != null && !bodyString.isEmpty()) {
                message2 = String.valueOf(message2) + ": " + bodyString;
            }
            throw new IOException(message2);
        }
        BufferedDataTable responseTable = this.nodeSettings.getResponseMapper().getTable(exec, response, this.getResponseType());
        if (this.getNrInPorts() == 0) {
            return new PortObject[]{responseTable};
        }
        return new PortObject[]{responseTable, inObjects[0]};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        try {
            this.nodeSettings.validateSettings();
        }
        catch (InvalidSettingsException invalidSettingsException) {
            throw new InvalidSettingsException("Missing configuration \u2013 please configure the node.");
        }
        DataTableSpec responseSpec = this.nodeSettings.getResponseMapper().getSpec(this.getResponseType());
        if (this.getNrInPorts() == 0) {
            return new PortObjectSpec[]{responseSpec};
        }
        return new PortObjectSpec[]{responseSpec, inSpecs[0]};
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettingsFrom(settings);
    }

    protected void reset() {
    }

    private String getResponseType() {
        return "application/json";
    }
}

