/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getuserssavedtracks;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetUsersSavedTracksNodeSettings {
    private static final String MARKET_KEY = "market";
    private static final String MARKET_DEFAULT_VALUE = null;
    private String market = MARKET_DEFAULT_VALUE;
    private static final String MARKET_ENABLED_KEY = "marketEnabled";
    private boolean marketEnabled = false;
    private static final String LIMIT_KEY = "limit";
    static final Integer LIMIT_DEFAULT_VALUE = 20;
    static final Integer LIMIT_MINIMUM_VALUE = 1;
    static final Integer LIMIT_MAXIMUM_VALUE = 50;
    private int limit = LIMIT_DEFAULT_VALUE;
    private static final String LIMIT_ENABLED_KEY = "limitEnabled";
    private boolean limitEnabled = false;
    private static final String OFFSET_KEY = "offset";
    static final Integer OFFSET_DEFAULT_VALUE = 0;
    static final Integer OFFSET_MINIMUM_VALUE = null;
    static final Integer OFFSET_MAXIMUM_VALUE = null;
    private int offset = OFFSET_DEFAULT_VALUE;
    private static final String OFFSET_ENABLED_KEY = "offsetEnabled";
    private boolean offsetEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"href\":\"rows[0][0]\",\"limit\":\"rows[0][1]\",\"next\":\"rows[0][2]\",\"offset\":\"rows[0][3]\",\"previous\":\"rows[0][4]\",\"total\":\"rows[0][5]\",\"items\":\"rows[0][6]\"}}]").addBodyColumn(new DataColumnSpecCreator("Href", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Limit", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Next", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Offset", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Previous", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Total", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Items", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetUsersSavedTracksNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(MARKET_KEY, this.market);
        settings.addBoolean(MARKET_ENABLED_KEY, this.marketEnabled);
        settings.addInt(LIMIT_KEY, this.limit);
        settings.addBoolean(LIMIT_ENABLED_KEY, this.limitEnabled);
        settings.addInt(OFFSET_KEY, this.offset);
        settings.addBoolean(OFFSET_ENABLED_KEY, this.offsetEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.market = settings.getString(MARKET_KEY, MARKET_DEFAULT_VALUE);
        this.marketEnabled = settings.getBoolean(MARKET_ENABLED_KEY, false);
        this.limit = settings.getInt(LIMIT_KEY, LIMIT_DEFAULT_VALUE.intValue());
        this.limitEnabled = settings.getBoolean(LIMIT_ENABLED_KEY, false);
        this.offset = settings.getInt(OFFSET_KEY, OFFSET_DEFAULT_VALUE.intValue());
        this.offsetEnabled = settings.getBoolean(OFFSET_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String market() {
        return this.market;
    }

    void market(String value) {
        this.market = value;
    }

    boolean marketEnabled() {
        return this.marketEnabled;
    }

    void marketEnabled(boolean value) {
        this.marketEnabled = value;
    }

    int limit() {
        return this.limit;
    }

    void limit(int value) {
        this.limit = value;
    }

    boolean limitEnabled() {
        return this.limitEnabled;
    }

    void limitEnabled(boolean value) {
        this.limitEnabled = value;
    }

    int offset() {
        return this.offset;
    }

    void offset(int value) {
        this.offset = value;
    }

    boolean offsetEnabled() {
        return this.offsetEnabled;
    }

    void offsetEnabled(boolean value) {
        this.offsetEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

