/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.search;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class SearchNodeSettings {
    private static final String Q_KEY = "q";
    private static final String Q_DEFAULT_VALUE = null;
    private String q = Q_DEFAULT_VALUE;
    static final String[] TYPE_VALUES = new String[]{"album", "artist", "playlist", "track", "show", "episode", "audiobook"};
    private static final String TYPE_KEY = "type";
    private static final String[] TYPE_DEFAULT_VALUE = new String[]{TYPE_VALUES[0]};
    private String[] type = TYPE_DEFAULT_VALUE;
    private static final String MARKET_KEY = "market";
    private static final String MARKET_DEFAULT_VALUE = null;
    private String market = MARKET_DEFAULT_VALUE;
    private static final String MARKET_ENABLED_KEY = "marketEnabled";
    private boolean marketEnabled = false;
    private static final String LIMIT_KEY = "limit";
    static final Integer LIMIT_DEFAULT_VALUE = 20;
    static final Integer LIMIT_MINIMUM_VALUE = 1;
    static final Integer LIMIT_MAXIMUM_VALUE = 50;
    private int limit = LIMIT_DEFAULT_VALUE;
    private static final String LIMIT_ENABLED_KEY = "limitEnabled";
    private boolean limitEnabled = false;
    private static final String OFFSET_KEY = "offset";
    static final Integer OFFSET_DEFAULT_VALUE = 0;
    static final Integer OFFSET_MINIMUM_VALUE = 0;
    static final Integer OFFSET_MAXIMUM_VALUE = 1000;
    private int offset = OFFSET_DEFAULT_VALUE;
    private static final String OFFSET_ENABLED_KEY = "offsetEnabled";
    private boolean offsetEnabled = false;
    static final String[] INCLUDE_EXTERNAL_VALUES = new String[]{"audio"};
    private static final String INCLUDE_EXTERNAL_KEY = "includeExternal";
    private static final String INCLUDE_EXTERNAL_DEFAULT_VALUE = INCLUDE_EXTERNAL_VALUES[0];
    private String includeExternal = INCLUDE_EXTERNAL_DEFAULT_VALUE;
    private static final String INCLUDE_EXTERNAL_ENABLED_KEY = "includeExternalEnabled";
    private boolean includeExternalEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"tracks\":\"rows[0][0]\",\"artists\":\"rows[0][1]\",\"albums\":\"rows[0][2]\",\"playlists\":\"rows[0][3]\",\"shows\":\"rows[0][4]\",\"episodes\":\"rows[0][5]\",\"audiobooks\":\"rows[0][6]\"}}]").addBodyColumn(new DataColumnSpecCreator("Tracks", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Artists", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Albums", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Playlists", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Shows", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Episodes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Audiobooks", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    SearchNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(Q_KEY, this.q);
        settings.addStringArray(TYPE_KEY, this.type);
        settings.addString(MARKET_KEY, this.market);
        settings.addBoolean(MARKET_ENABLED_KEY, this.marketEnabled);
        settings.addInt(LIMIT_KEY, this.limit);
        settings.addBoolean(LIMIT_ENABLED_KEY, this.limitEnabled);
        settings.addInt(OFFSET_KEY, this.offset);
        settings.addBoolean(OFFSET_ENABLED_KEY, this.offsetEnabled);
        settings.addString(INCLUDE_EXTERNAL_KEY, this.includeExternal);
        settings.addBoolean(INCLUDE_EXTERNAL_ENABLED_KEY, this.includeExternalEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.q = settings.getString(Q_KEY, Q_DEFAULT_VALUE);
        this.type = settings.getStringArray(TYPE_KEY, TYPE_DEFAULT_VALUE);
        this.market = settings.getString(MARKET_KEY, MARKET_DEFAULT_VALUE);
        this.marketEnabled = settings.getBoolean(MARKET_ENABLED_KEY, false);
        this.limit = settings.getInt(LIMIT_KEY, LIMIT_DEFAULT_VALUE.intValue());
        this.limitEnabled = settings.getBoolean(LIMIT_ENABLED_KEY, false);
        this.offset = settings.getInt(OFFSET_KEY, OFFSET_DEFAULT_VALUE.intValue());
        this.offsetEnabled = settings.getBoolean(OFFSET_ENABLED_KEY, false);
        this.includeExternal = settings.getString(INCLUDE_EXTERNAL_KEY, INCLUDE_EXTERNAL_DEFAULT_VALUE);
        this.includeExternalEnabled = settings.getBoolean(INCLUDE_EXTERNAL_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.q == null || this.q.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cQ\u201d is required.");
        }
        if (this.type == null || this.type.length == 0) {
            throw new InvalidSettingsException("Value for \u201cType\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String q() {
        return this.q;
    }

    void q(String value) {
        this.q = value;
    }

    String[] type() {
        return this.type;
    }

    void type(String[] value) {
        this.type = value;
    }

    String market() {
        return this.market;
    }

    void market(String value) {
        this.market = value;
    }

    boolean marketEnabled() {
        return this.marketEnabled;
    }

    void marketEnabled(boolean value) {
        this.marketEnabled = value;
    }

    int limit() {
        return this.limit;
    }

    void limit(int value) {
        this.limit = value;
    }

    boolean limitEnabled() {
        return this.limitEnabled;
    }

    void limitEnabled(boolean value) {
        this.limitEnabled = value;
    }

    int offset() {
        return this.offset;
    }

    void offset(int value) {
        this.offset = value;
    }

    boolean offsetEnabled() {
        return this.offsetEnabled;
    }

    void offsetEnabled(boolean value) {
        this.offsetEnabled = value;
    }

    String includeExternal() {
        return this.includeExternal;
    }

    void includeExternal(String value) {
        this.includeExternal = value;
    }

    boolean includeExternalEnabled() {
        return this.includeExternalEnabled;
    }

    void includeExternalEnabled(boolean value) {
        this.includeExternalEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

