/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.toggleshuffleforusersplayback;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class ToggleShuffleForUsersPlaybackNodeSettings {
    private static final String STATE_KEY = "state";
    private static final boolean STATE_DEFAULT_VALUE = false;
    private boolean state = false;
    private static final String DEVICE_ID_KEY = "deviceId";
    private static final String DEVICE_ID_DEFAULT_VALUE = null;
    private String deviceId = DEVICE_ID_DEFAULT_VALUE;
    private static final String DEVICE_ID_ENABLED_KEY = "deviceIdEnabled";
    private boolean deviceIdEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    ToggleShuffleForUsersPlaybackNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addBoolean(STATE_KEY, this.state);
        settings.addString(DEVICE_ID_KEY, this.deviceId);
        settings.addBoolean(DEVICE_ID_ENABLED_KEY, this.deviceIdEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.state = settings.getBoolean(STATE_KEY, false);
        this.deviceId = settings.getString(DEVICE_ID_KEY, DEVICE_ID_DEFAULT_VALUE);
        this.deviceIdEnabled = settings.getBoolean(DEVICE_ID_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    boolean state() {
        return this.state;
    }

    void state(boolean value) {
        this.state = value;
    }

    String deviceId() {
        return this.deviceId;
    }

    void deviceId(String value) {
        this.deviceId = value;
    }

    boolean deviceIdEnabled() {
        return this.deviceIdEnabled;
    }

    void deviceIdEnabled(boolean value) {
        this.deviceIdEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

