/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.auth.oauth20;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.nodepit.nodes.spotify.v1.InterceptorFactory;
import com.nodepit.nodes.spotify.v1.auth.oauth20.Oauth20NodeDialog;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class Oauth20InterceptorFactory
extends InterceptorFactory<Oauth20Data> {
    public static final String IDENTIFIER = "oauth_2_0";

    public Oauth20InterceptorFactory() {
        super(IDENTIFIER, Oauth20Data.class);
    }

    @Override
    protected Interceptor createInterceptor(final Oauth20Data data) {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                String renewedAccessToken = this.refreshToken(data);
                Request authRequest = originalRequest.newBuilder().header("Authorization", "Bearer " + renewedAccessToken).build();
                return chain.proceed(authRequest);
            }

            private String refreshToken(Oauth20Data data2) {
                OAuth2AccessToken accessToken;
                System.out.println("renewing token \u2026");
                System.out.println("refresh token = " + data2.refreshToken);
                String scopeValue = Arrays.stream(data2.scopes).collect(Collectors.joining(","));
                OAuth20Service oauthService = new ServiceBuilder(data2.clientId).apiSecret(data2.clientSecret).callback("http://localhost:54321").defaultScope(scopeValue).build((DefaultApi20)new Oauth20NodeDialog.OAuthAPI());
                try {
                    accessToken = oauthService.refreshAccessToken(data2.refreshToken);
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new IllegalStateException("Could not refresh access token", e);
                }
                String newAccessToken = accessToken.getAccessToken();
                System.out.println("renewed access token = " + newAccessToken);
                return newAccessToken;
            }
        };
    }

    public static final class Oauth20Data {
        String clientId;
        String clientSecret;
        String refreshToken;
        String[] scopes;
    }
}

