/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.auth.oauth20;

import com.nodepit.nodes.spotify.v1.auth.oauth20.Oauth20InterceptorFactory;
import com.nodepit.nodes.spotify.v1.auth.oauth20.Oauth20NodeSettings;
import com.nodepit.nodes.spotify.v1.port.ConfigPortObject;
import com.nodepit.nodes.spotify.v1.port.ConfigPortObjectSpec;
import java.io.File;
import java.io.IOException;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

class Oauth20NodeModel
extends NodeModel {
    private final Oauth20NodeSettings nodeSettings = new Oauth20NodeSettings();

    protected Oauth20NodeModel() {
        super(new PortType[0], new PortType[]{ConfigPortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        return new PortObject[]{new ConfigPortObject(this.createSpec(null))};
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[]{this.createSpec(null)};
    }

    private ConfigPortObjectSpec createSpec(ConfigPortObjectSpec inSpec) throws InvalidSettingsException {
        Oauth20InterceptorFactory.Oauth20Data data = new Oauth20InterceptorFactory.Oauth20Data();
        data.clientId = this.nodeSettings.clientId();
        if (data.clientId == null || data.clientId.isEmpty()) {
            throw new InvalidSettingsException("Missing Client ID. Please configure the node.");
        }
        data.clientSecret = this.nodeSettings.clientSecret();
        if (data.clientSecret == null || data.clientSecret.isEmpty()) {
            throw new InvalidSettingsException("Missing Client Secret. Please configure the node.");
        }
        data.refreshToken = this.nodeSettings.refreshToken();
        if (data.refreshToken == null || data.refreshToken.isEmpty()) {
            throw new InvalidSettingsException("Missing refresh token. Please configure the node.");
        }
        data.scopes = this.nodeSettings.scope();
        ConfigPortObjectSpec spec = ConfigPortObjectSpec.getOrDefault(inSpec);
        return spec.append(new ConfigPortObjectSpec.InterceptorConfig("oauth_2_0", data));
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettingsFrom(settings);
    }

    protected void reset() {
    }
}

