/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.addtoqueue;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class AddToQueueNodeSettings {
    private static final String URI_KEY = "uri";
    private static final String URI_DEFAULT_VALUE = null;
    private String uri = URI_DEFAULT_VALUE;
    private static final String DEVICE_ID_KEY = "deviceId";
    private static final String DEVICE_ID_DEFAULT_VALUE = null;
    private String deviceId = DEVICE_ID_DEFAULT_VALUE;
    private static final String DEVICE_ID_ENABLED_KEY = "deviceIdEnabled";
    private boolean deviceIdEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    AddToQueueNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(URI_KEY, this.uri);
        settings.addString(DEVICE_ID_KEY, this.deviceId);
        settings.addBoolean(DEVICE_ID_ENABLED_KEY, this.deviceIdEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.uri = settings.getString(URI_KEY, URI_DEFAULT_VALUE);
        this.deviceId = settings.getString(DEVICE_ID_KEY, DEVICE_ID_DEFAULT_VALUE);
        this.deviceIdEnabled = settings.getBoolean(DEVICE_ID_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.uri == null || this.uri.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cUri\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String uri() {
        return this.uri;
    }

    void uri(String value) {
        this.uri = value;
    }

    String deviceId() {
        return this.deviceId;
    }

    void deviceId(String value) {
        this.deviceId = value;
    }

    boolean deviceIdEnabled() {
        return this.deviceIdEnabled;
    }

    void deviceIdEnabled(boolean value) {
        this.deviceIdEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

