/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.checkifuserfollowsplaylist;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class CheckIfUserFollowsPlaylistNodeSettings {
    private static final String PLAYLIST_ID_KEY = "playlistId";
    private static final String PLAYLIST_ID_DEFAULT_VALUE = null;
    private String playlistId = PLAYLIST_ID_DEFAULT_VALUE;
    private static final String IDS_KEY = "ids";
    private static final String IDS_DEFAULT_VALUE = null;
    private String ids = IDS_DEFAULT_VALUE;
    private static final String IDS_ENABLED_KEY = "idsEnabled";
    private boolean idsEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    CheckIfUserFollowsPlaylistNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(PLAYLIST_ID_KEY, this.playlistId);
        settings.addString(IDS_KEY, this.ids);
        settings.addBoolean(IDS_ENABLED_KEY, this.idsEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.playlistId = settings.getString(PLAYLIST_ID_KEY, PLAYLIST_ID_DEFAULT_VALUE);
        this.ids = settings.getString(IDS_KEY, IDS_DEFAULT_VALUE);
        this.idsEnabled = settings.getBoolean(IDS_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.playlistId == null || this.playlistId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cPlaylist Id\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String playlistId() {
        return this.playlistId;
    }

    void playlistId(String value) {
        this.playlistId = value;
    }

    String ids() {
        return this.ids;
    }

    void ids(String value) {
        this.ids = value;
    }

    boolean idsEnabled() {
        return this.idsEnabled;
    }

    void idsEnabled(boolean value) {
        this.idsEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

