/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.createplaylist;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import com.nodepit.nodes.spotify.v1.Utils;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class CreatePlaylistNodeSettings {
    private static final String USER_ID_KEY = "userId";
    private static final String USER_ID_DEFAULT_VALUE = null;
    private String userId = USER_ID_DEFAULT_VALUE;
    private static final String BODY_KEY = "body";
    private static final String BODY_DEFAULT_VALUE = Utils.readToString("body_example.json", CreatePlaylistNodeSettings.class);
    private static final String BODY_JSON_SCHEMA_FILE = "body_schema.json";
    private String body = BODY_DEFAULT_VALUE;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"collaborative\":\"rows[0][0]\",\"description\":\"rows[0][1]\",\"external_urls\":\"rows[0][2]\",\"followers\":\"rows[0][3]\",\"href\":\"rows[0][4]\",\"id\":\"rows[0][5]\",\"images\":\"rows[0][6]\",\"name\":\"rows[0][7]\",\"owner\":\"rows[0][8]\",\"public\":\"rows[0][9]\",\"snapshot_id\":\"rows[0][10]\",\"tracks\":\"rows[0][11]\",\"type\":\"rows[0][12]\",\"uri\":\"rows[0][13]\"}}]").addBodyColumn(new DataColumnSpecCreator("Collaborative", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Description", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("External Urls", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Followers", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Href", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Images", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Name", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Owner", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Public", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Snapshot Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Tracks", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Uri", StringCell.StringCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    CreatePlaylistNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(USER_ID_KEY, this.userId);
        settings.addString(BODY_KEY, this.body);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.userId = settings.getString(USER_ID_KEY, USER_ID_DEFAULT_VALUE);
        this.body = settings.getString(BODY_KEY, BODY_DEFAULT_VALUE);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.userId == null || this.userId.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cUser Id\u201d is required.");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cBody\u201d is required.");
        }
        if (!Utils.validateJsonBySchema(this.body, BODY_JSON_SCHEMA_FILE, this.getClass())) {
            throw new InvalidSettingsException("\u201cBody\u201d does not conform to the JSON schema.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String userId() {
        return this.userId;
    }

    void userId(String value) {
        this.userId = value;
    }

    String body() {
        return this.body;
    }

    void body(String value) {
        this.body = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

