/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getcategories;

import com.nodepit.nodes.spotify.v1.LabelButton;
import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.operation.getcategories.GetCategoriesNodeSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.port.PortObjectSpec;

class GetCategoriesNodeDialog
extends NodeDialogPane {
    private final GetCategoriesNodeSettings nodeSettings = new GetCategoriesNodeSettings();
    private JTextField locale;
    private JCheckBox localeEnabled;
    private JSpinner limit;
    private JCheckBox limitEnabled;
    private JSpinner offset;
    private JCheckBox offsetEnabled;
    private JComboBox<ResponseMapper> resultFormat;

    GetCategoriesNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label0 = new LabelButton("Locale:");
        panel.add((Component)label0, c);
        ++c.gridx;
        c.anchor = 17;
        this.localeEnabled = new JCheckBox();
        this.localeEnabled.addActionListener(e -> this.updateComponents());
        label0.addActionListener(e -> {
            this.localeEnabled.setSelected(!this.localeEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.localeEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.locale = new JTextField(30);
        panel.add((Component)this.locale, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label1 = new LabelButton("Limit:");
        panel.add((Component)label1, c);
        ++c.gridx;
        c.anchor = 17;
        this.limitEnabled = new JCheckBox();
        this.limitEnabled.addActionListener(e -> this.updateComponents());
        label1.addActionListener(e -> {
            this.limitEnabled.setSelected(!this.limitEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.limitEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.limit = new JSpinner(new SpinnerNumberModel(GetCategoriesNodeSettings.LIMIT_DEFAULT_VALUE, GetCategoriesNodeSettings.LIMIT_MINIMUM_VALUE, GetCategoriesNodeSettings.LIMIT_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.limit, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        LabelButton label2 = new LabelButton("Offset:");
        panel.add((Component)label2, c);
        ++c.gridx;
        c.anchor = 17;
        this.offsetEnabled = new JCheckBox();
        this.offsetEnabled.addActionListener(e -> this.updateComponents());
        label2.addActionListener(e -> {
            this.offsetEnabled.setSelected(!this.offsetEnabled.isSelected());
            this.updateComponents();
        });
        panel.add((Component)this.offsetEnabled, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.offset = new JSpinner(new SpinnerNumberModel(GetCategoriesNodeSettings.OFFSET_DEFAULT_VALUE, GetCategoriesNodeSettings.OFFSET_MINIMUM_VALUE, GetCategoriesNodeSettings.OFFSET_MAXIMUM_VALUE, (Number)1));
        panel.add((Component)this.offset, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)new LabelButton("Result Format:"), c);
        ++c.gridx;
        c.anchor = 17;
        panel.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.resultFormat = new JComboBox<ResponseMapper>(GetCategoriesNodeSettings.MAPPERS);
        this.resultFormat.setRenderer(new ResponseMapper.ListCellRenderer());
        panel.add(this.resultFormat, c);
        ++c.gridy;
        return panel;
    }

    private void updateComponents() {
        this.locale.setEnabled(this.localeEnabled.isSelected());
        this.limit.setEnabled(this.limitEnabled.isSelected());
        this.offset.setEnabled(this.offsetEnabled.isSelected());
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        this.nodeSettings.locale(this.locale.getText());
        this.nodeSettings.localeEnabled(this.localeEnabled.isSelected());
        this.nodeSettings.limit((Integer)this.limit.getValue());
        this.nodeSettings.limitEnabled(this.limitEnabled.isSelected());
        this.nodeSettings.offset((Integer)this.offset.getValue());
        this.nodeSettings.offsetEnabled(this.offsetEnabled.isSelected());
        this.nodeSettings.resultFormat(((ResponseMapper)this.resultFormat.getSelectedItem()).identifier());
        this.nodeSettings.validateSettings();
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.nodeSettings.loadSettingsFrom(settings);
        this.locale.setText(this.nodeSettings.locale());
        this.localeEnabled.setSelected(this.nodeSettings.localeEnabled());
        this.limit.setValue(this.nodeSettings.limit());
        this.limitEnabled.setSelected(this.nodeSettings.limitEnabled());
        this.offset.setValue(this.nodeSettings.offset());
        this.offsetEnabled.setSelected(this.nodeSettings.offsetEnabled());
        this.resultFormat.setSelectedItem(this.nodeSettings.getResponseMapper());
        this.updateComponents();
    }
}

