/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getfeaturedplaylists;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetFeaturedPlaylistsNodeSettings {
    private static final String LOCALE_KEY = "locale";
    private static final String LOCALE_DEFAULT_VALUE = null;
    private String locale = LOCALE_DEFAULT_VALUE;
    private static final String LOCALE_ENABLED_KEY = "localeEnabled";
    private boolean localeEnabled = false;
    private static final String LIMIT_KEY = "limit";
    static final Integer LIMIT_DEFAULT_VALUE = 20;
    static final Integer LIMIT_MINIMUM_VALUE = 1;
    static final Integer LIMIT_MAXIMUM_VALUE = 50;
    private int limit = LIMIT_DEFAULT_VALUE;
    private static final String LIMIT_ENABLED_KEY = "limitEnabled";
    private boolean limitEnabled = false;
    private static final String OFFSET_KEY = "offset";
    static final Integer OFFSET_DEFAULT_VALUE = 0;
    static final Integer OFFSET_MINIMUM_VALUE = null;
    static final Integer OFFSET_MAXIMUM_VALUE = null;
    private int offset = OFFSET_DEFAULT_VALUE;
    private static final String OFFSET_ENABLED_KEY = "offsetEnabled";
    private boolean offsetEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"message\":\"rows[0][0]\",\"playlists\":\"rows[0][1]\"}}]").addBodyColumn(new DataColumnSpecCreator("Message", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Playlists", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetFeaturedPlaylistsNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(LOCALE_KEY, this.locale);
        settings.addBoolean(LOCALE_ENABLED_KEY, this.localeEnabled);
        settings.addInt(LIMIT_KEY, this.limit);
        settings.addBoolean(LIMIT_ENABLED_KEY, this.limitEnabled);
        settings.addInt(OFFSET_KEY, this.offset);
        settings.addBoolean(OFFSET_ENABLED_KEY, this.offsetEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.locale = settings.getString(LOCALE_KEY, LOCALE_DEFAULT_VALUE);
        this.localeEnabled = settings.getBoolean(LOCALE_ENABLED_KEY, false);
        this.limit = settings.getInt(LIMIT_KEY, LIMIT_DEFAULT_VALUE.intValue());
        this.limitEnabled = settings.getBoolean(LIMIT_ENABLED_KEY, false);
        this.offset = settings.getInt(OFFSET_KEY, OFFSET_DEFAULT_VALUE.intValue());
        this.offsetEnabled = settings.getBoolean(OFFSET_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String locale() {
        return this.locale;
    }

    void locale(String value) {
        this.locale = value;
    }

    boolean localeEnabled() {
        return this.localeEnabled;
    }

    void localeEnabled(boolean value) {
        this.localeEnabled = value;
    }

    int limit() {
        return this.limit;
    }

    void limit(int value) {
        this.limit = value;
    }

    boolean limitEnabled() {
        return this.limitEnabled;
    }

    void limitEnabled(boolean value) {
        this.limitEnabled = value;
    }

    int offset() {
        return this.offset;
    }

    void offset(int value) {
        this.offset = value;
    }

    boolean offsetEnabled() {
        return this.offsetEnabled;
    }

    void offsetEnabled(boolean value) {
        this.offsetEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

