/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.spotify.v1.operation.getfollowed;

import com.nodepit.nodes.spotify.v1.ResponseMapper;
import com.nodepit.nodes.spotify.v1.SimpleResponseMapper;
import com.nodepit.nodes.spotify.v1.TransformToTableMapper;
import java.util.Arrays;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

class GetFollowedNodeSettings {
    static final String[] TYPE_VALUES = new String[]{"artist"};
    private static final String TYPE_KEY = "type";
    private static final String TYPE_DEFAULT_VALUE = TYPE_VALUES[0];
    private String type = TYPE_DEFAULT_VALUE;
    private static final String AFTER_KEY = "after";
    private static final String AFTER_DEFAULT_VALUE = null;
    private String after = AFTER_DEFAULT_VALUE;
    private static final String AFTER_ENABLED_KEY = "afterEnabled";
    private boolean afterEnabled = false;
    private static final String LIMIT_KEY = "limit";
    static final Integer LIMIT_DEFAULT_VALUE = 20;
    static final Integer LIMIT_MINIMUM_VALUE = 1;
    static final Integer LIMIT_MAXIMUM_VALUE = 50;
    private int limit = LIMIT_DEFAULT_VALUE;
    private static final String LIMIT_ENABLED_KEY = "limitEnabled";
    private boolean limitEnabled = false;
    static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"artists\":{\"href\":\"rows[0][0]\",\"limit\":\"rows[0][1]\",\"next\":\"rows[0][2]\",\"cursors\":\"rows[0][3]\",\"total\":\"rows[0][4]\",\"items\":\"rows[0][5]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Href", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Limit", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Next", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Cursors", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Total", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Items", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};
    private static final String RESULT_FORMAT_KEY = "resultFormat";
    private static final String RESULT_FORMAT_DEFAULT_VALUE = MAPPERS[0].identifier();
    private String resultFormat = RESULT_FORMAT_DEFAULT_VALUE;

    GetFollowedNodeSettings() {
    }

    void saveSettingsTo(NodeSettingsWO settings) {
        settings.addString(TYPE_KEY, this.type);
        settings.addString(AFTER_KEY, this.after);
        settings.addBoolean(AFTER_ENABLED_KEY, this.afterEnabled);
        settings.addInt(LIMIT_KEY, this.limit);
        settings.addBoolean(LIMIT_ENABLED_KEY, this.limitEnabled);
        settings.addString(RESULT_FORMAT_KEY, this.resultFormat);
    }

    void loadSettingsFrom(NodeSettingsRO settings) {
        this.type = settings.getString(TYPE_KEY, TYPE_DEFAULT_VALUE);
        this.after = settings.getString(AFTER_KEY, AFTER_DEFAULT_VALUE);
        this.afterEnabled = settings.getBoolean(AFTER_ENABLED_KEY, false);
        this.limit = settings.getInt(LIMIT_KEY, LIMIT_DEFAULT_VALUE.intValue());
        this.limitEnabled = settings.getBoolean(LIMIT_ENABLED_KEY, false);
        this.resultFormat = settings.getString(RESULT_FORMAT_KEY, "raw_response");
    }

    void validateSettings() throws InvalidSettingsException {
        if (this.type == null || this.type.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cType\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    String type() {
        return this.type;
    }

    void type(String value) {
        this.type = value;
    }

    String after() {
        return this.after;
    }

    void after(String value) {
        this.after = value;
    }

    boolean afterEnabled() {
        return this.afterEnabled;
    }

    void afterEnabled(boolean value) {
        this.afterEnabled = value;
    }

    int limit() {
        return this.limit;
    }

    void limit(int value) {
        this.limit = value;
    }

    boolean limitEnabled() {
        return this.limitEnabled;
    }

    void limitEnabled(boolean value) {
        this.limitEnabled = value;
    }

    String resultFormat() {
        return this.resultFormat;
    }

    void resultFormat(String value) {
        this.resultFormat = value;
    }

    ResponseMapper getResponseMapper() {
        String resultFormat = this.resultFormat();
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
    }
}

