/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1;

import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okhttp3.RequestBody;
import org.knime.node.parameters.NodeParameters;

public interface HttpRequestNodeParameters
extends NodeParameters {
    public HttpRequestParams getRequestParams();

    public static enum BodyType {
        NONE,
        JSON,
        FORM,
        MULTIPART;

    }

    public record File(String value) {
        final String getFilename() {
            return Utils.getFilename(this.value);
        }

        final RequestBody getRequestBody() {
            return Utils.getRequestBody(this.value);
        }
    }

    public static final class HttpRequestParams {
        private final String method;
        private final String path;
        private final List<Param> params;
        private final BodyType bodyType;
        private final String jsonBody;
        private final String responseType;
        private final ResponseMapper responseMapper;

        HttpRequestParams(Builder builder) {
            this.method = builder.method;
            this.path = builder.path;
            this.params = new ArrayList<Param>(builder.params);
            this.bodyType = builder.bodyType;
            this.jsonBody = builder.jsonBody;
            this.responseType = builder.responseType;
            this.responseMapper = builder.responseMapper;
        }

        public String getMethod() {
            return this.method;
        }

        public String getPath() {
            return this.path;
        }

        public List<Param> getParams(ParamType type) {
            return this.params.stream().filter(p -> p.type() == type).toList();
        }

        public BodyType getBodyType() {
            return this.bodyType;
        }

        public String getJsonBody() {
            return this.jsonBody;
        }

        public String getResponseType() {
            return this.responseType;
        }

        public ResponseMapper getResponseMapper() {
            return this.responseMapper;
        }

        public static final class Builder {
            private String method;
            private String path;
            private List<Param> params = new ArrayList<Param>();
            private BodyType bodyType;
            private String jsonBody;
            private String responseType;
            private ResponseMapper responseMapper;

            public void setMethod(String method) {
                this.method = method;
            }

            public void setPath(String path) {
                this.path = path;
            }

            public void addParam(Param param) {
                this.params.add(param);
            }

            public void setBodyType(BodyType bodyType) {
                this.bodyType = bodyType;
            }

            public void setJsonBody(String jsonBody) {
                this.jsonBody = jsonBody;
            }

            public void setResponseType(String responseType) {
                this.responseType = responseType;
            }

            public void pickResponseMapper(ResponseMapper[] mappers, String resultFormat) {
                this.responseMapper = Arrays.stream(mappers).filter(m -> m.identifier().equals(resultFormat)).findFirst().orElseThrow();
            }

            public HttpRequestParams build() {
                return new HttpRequestParams(this);
            }
        }
    }

    public record Param(ParamType type, String name, Object value) {
    }

    public static enum ParamType {
        PATH,
        QUERY,
        HEADER,
        COOKIE,
        BODY;

    }
}

