/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.addpagenumbers;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.number.NumberInputWidgetValidation;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

final class AddPageNumbersNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Page Numbers", description="The pages to select, Supports ranges (e.g., '1,3,5-9'), or 'all' or functions in the format 'an+b' where 'a' is the multiplier of the page number 'n', and 'b' is a constant (e.g., '2n+1', '3n', '6n-5')\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String pageNumbers = "all";
    @Widget(title="Set Custom Margin", description="Enable to set the optional field <b>Custom Margin</b>")
    @ValueReference(value=CustomMarginEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean customMarginEnabled = false;
    @Widget(title="Custom Margin", description="Custom margin: small/medium/large/x-large\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=CustomMarginEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Custom_MarginChoicesProvider.class)
    String customMargin = "medium";
    private static final String[] CUSTOM_MARGIN_VALUES = new String[]{"small", "medium", "large", "x-large"};
    @Widget(title="Font Size", description="Font size for page numbers\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget(minValidation=Font_SizeMinValidation.class)
    double fontSize = 12.0;
    @Widget(title="Font Type", description="Font type for page numbers\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Font_TypeChoicesProvider.class)
    String fontType = FONT_TYPE_VALUES[0];
    private static final String[] FONT_TYPE_VALUES = new String[]{"helvetica", "courier", "times"};
    @Widget(title="Set Font Color", description="Enable to set the optional field <b>Font Color</b>")
    @ValueReference(value=FontColorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fontColorEnabled = false;
    @Widget(title="Font Color", description="Hex colour for page numbers (e.g. #FF0000)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FontColorEnabledRef.class, type=Effect.EffectType.SHOW)
    String fontColor = "#000000";
    @Widget(title="Position", description="Position: 1-9 representing positions on the page (1=top-left, 2=top-center, 3=top-right, 4=middle-left, 5=middle-center, 6=middle-right, 7=bottom-left, 8=bottom-center, 9=bottom-right)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    int position = 0;
    @Widget(title="Starting Number", description="Starting number for page numbering\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget(minValidation=Starting_NumberMinValidation.class)
    int startingNumber = 1;
    @Widget(title="Set Pages to Number", description="Enable to set the optional field <b>Pages to Number</b>")
    @ValueReference(value=PagesToNumberEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pagesToNumberEnabled = false;
    @Widget(title="Pages to Number", description="Which pages to number (e.g. '1,3-5,7' or 'all')\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PagesToNumberEnabledRef.class, type=Effect.EffectType.SHOW)
    String pagesToNumber = "all";
    @Widget(title="Set Custom Text", description="Enable to set the optional field <b>Custom Text</b>")
    @ValueReference(value=CustomTextEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean customTextEnabled = false;
    @Widget(title="Custom Text", description="Custom text pattern. Available variables: {n}=current page number, {total}=total pages, {filename}=original filename\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=CustomTextEnabledRef.class, type=Effect.EffectType.SHOW)
    String customText = "{n}";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=AddPageNumbersNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    AddPageNumbersNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.pageNumbers == null || this.pageNumbers.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cPage Numbers\u201d is required.");
        }
        if (this.fontType == null || this.fontType.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFont Type\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/misc/add-page-numbers");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "pageNumbers", this.pageNumbers));
        if (this.customMarginEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "customMargin", this.customMargin));
        }
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fontSize", this.fontSize));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fontType", this.fontType));
        if (this.fontColorEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fontColor", this.fontColor));
        }
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "position", this.position));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "startingNumber", this.startingNumber));
        if (this.pagesToNumberEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "pagesToNumber", this.pagesToNumber));
        }
        if (this.customTextEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "customText", this.customText));
        }
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class AddPageNumbersNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private AddPageNumbersNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class CustomMarginEnabledRef
    implements BooleanReference {
        private CustomMarginEnabledRef() {
        }
    }

    private static final class CustomTextEnabledRef
    implements BooleanReference {
        private CustomTextEnabledRef() {
        }
    }

    private static final class Custom_MarginChoicesProvider
    implements StringChoicesProvider {
        private Custom_MarginChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(CUSTOM_MARGIN_VALUES);
        }
    }

    private static final class FontColorEnabledRef
    implements BooleanReference {
        private FontColorEnabledRef() {
        }
    }

    private static final class Font_SizeMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private Font_SizeMinValidation() {
        }

        public double getMin() {
            return 1.0;
        }
    }

    private static final class Font_TypeChoicesProvider
    implements StringChoicesProvider {
        private Font_TypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(FONT_TYPE_VALUES);
        }
    }

    private static final class PagesToNumberEnabledRef
    implements BooleanReference {
        private PagesToNumberEnabledRef() {
        }
    }

    private static final class Starting_NumberMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private Starting_NumberMinValidation() {
        }

        public double getMin() {
            return 1.0;
        }
    }
}

