/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.addstamp;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

final class AddStampNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Page Numbers", description="The pages to select, Supports ranges (e.g., '1,3,5-9'), or 'all' or functions in the format 'an+b' where 'a' is the multiplier of the page number 'n', and 'b' is a constant (e.g., '2n+1', '3n', '6n-5')\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String pageNumbers = "all";
    @Widget(title="Stamp Type", description="The stamp type (text or image)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Stamp_TypeChoicesProvider.class)
    String stampType = STAMP_TYPE_VALUES[0];
    private static final String[] STAMP_TYPE_VALUES = new String[]{"text", "image"};
    @Widget(title="Set Stamp Text", description="Enable to set the optional field <b>Stamp Text</b>")
    @ValueReference(value=StampTextEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean stampTextEnabled = false;
    @Widget(title="Stamp Text", description="The stamp text\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=StampTextEnabledRef.class, type=Effect.EffectType.SHOW)
    String stampText = "Stirling Software";
    @Widget(title="Set Stamp Image", description="Enable to set the optional field <b>Stamp Image</b>")
    @ValueReference(value=StampImageEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean stampImageEnabled = false;
    @Widget(title="Stamp Image", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=StampImageEnabledRef.class, type=Effect.EffectType.SHOW)
    @LocalFileReaderWidget
    String stampImage = "";
    @Widget(title="Set Alphabet", description="Enable to set the optional field <b>Alphabet</b>")
    @ValueReference(value=AlphabetEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean alphabetEnabled = false;
    @Widget(title="Alphabet", description="The selected alphabet of the stamp text\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AlphabetEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=AlphabetChoicesProvider.class)
    String alphabet = "roman";
    private static final String[] ALPHABET_VALUES = new String[]{"roman", "arabic", "japanese", "korean", "chinese"};
    @Widget(title="Font Size", description="The font size of the stamp text and image\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    double fontSize = 30.0;
    @Widget(title="Rotation", description="The rotation of the stamp in degrees\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    double rotation = 0.0;
    @Widget(title="Opacity", description="The opacity of the stamp (0.0 - 1.0)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    double opacity = 0.5;
    @Widget(title="Position", description="Position for stamp placement based on a 1-9 grid (1: bottom-left, 2: bottom-center, 3: bottom-right, 4: middle-left, 5: middle-center, 6: middle-right, 7: top-left, 8: top-center, 9: top-right)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    int position = 0;
    @Widget(title="Override X", description="Override X coordinate for stamp placement. If set, it will override the position-based calculation. Negative value means no override.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    double overrideX = -1.0;
    @Widget(title="Override Y", description="Override Y coordinate for stamp placement. If set, it will override the position-based calculation. Negative value means no override.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    double overrideY = -1.0;
    @Widget(title="Custom Margin", description="Specifies the margin size for the stamp.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Custom_MarginChoicesProvider.class)
    String customMargin = "medium";
    private static final String[] CUSTOM_MARGIN_VALUES = new String[]{"small", "medium", "large", "x-large"};
    @Widget(title="Set Custom Color", description="Enable to set the optional field <b>Custom Color</b>")
    @ValueReference(value=CustomColorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean customColorEnabled = false;
    @Widget(title="Custom Color", description="The color of the stamp text\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=CustomColorEnabledRef.class, type=Effect.EffectType.SHOW)
    String customColor = "#d3d3d3";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=AddStampNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    AddStampNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.pageNumbers == null || this.pageNumbers.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cPage Numbers\u201d is required.");
        }
        if (this.stampType == null || this.stampType.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cStamp Type\u201d is required.");
        }
        if (this.customMargin == null || this.customMargin.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cCustom Margin\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/misc/add-stamp");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "pageNumbers", this.pageNumbers));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "stampType", this.stampType));
        if (this.stampTextEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "stampText", this.stampText));
        }
        if (this.stampImageEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "stampImage", new HttpRequestNodeParameters.File(this.stampImage)));
        }
        if (this.alphabetEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "alphabet", this.alphabet));
        }
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fontSize", this.fontSize));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "rotation", this.rotation));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "opacity", this.opacity));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "position", this.position));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "overrideX", this.overrideX));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "overrideY", this.overrideY));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "customMargin", this.customMargin));
        if (this.customColorEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "customColor", this.customColor));
        }
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class AddStampNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private AddStampNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class AlphabetChoicesProvider
    implements StringChoicesProvider {
        private AlphabetChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(ALPHABET_VALUES);
        }
    }

    private static final class AlphabetEnabledRef
    implements BooleanReference {
        private AlphabetEnabledRef() {
        }
    }

    private static final class CustomColorEnabledRef
    implements BooleanReference {
        private CustomColorEnabledRef() {
        }
    }

    private static final class Custom_MarginChoicesProvider
    implements StringChoicesProvider {
        private Custom_MarginChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(CUSTOM_MARGIN_VALUES);
        }
    }

    private static final class StampImageEnabledRef
    implements BooleanReference {
        private StampImageEnabledRef() {
        }
    }

    private static final class StampTextEnabledRef
    implements BooleanReference {
        private StampTextEnabledRef() {
        }
    }

    private static final class Stamp_TypeChoicesProvider
    implements StringChoicesProvider {
        private Stamp_TypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(STAMP_TYPE_VALUES);
        }
    }
}

