/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.addwatermark;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

final class AddWatermarkNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Watermark Type", description="The watermark type (text or image)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Watermark_TypeChoicesProvider.class)
    String watermarkType = WATERMARK_TYPE_VALUES[0];
    private static final String[] WATERMARK_TYPE_VALUES = new String[]{"text", "image"};
    @Widget(title="Set Watermark Text", description="Enable to set the optional field <b>Watermark Text</b>")
    @ValueReference(value=WatermarkTextEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean watermarkTextEnabled = false;
    @Widget(title="Watermark Text", description="The watermark text\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=WatermarkTextEnabledRef.class, type=Effect.EffectType.SHOW)
    String watermarkText = "Stirling Software";
    @Widget(title="Set Watermark Image", description="Enable to set the optional field <b>Watermark Image</b>")
    @ValueReference(value=WatermarkImageEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean watermarkImageEnabled = false;
    @Widget(title="Watermark Image", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=WatermarkImageEnabledRef.class, type=Effect.EffectType.SHOW)
    @LocalFileReaderWidget
    String watermarkImage = "";
    @Widget(title="Set Alphabet", description="Enable to set the optional field <b>Alphabet</b>")
    @ValueReference(value=AlphabetEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean alphabetEnabled = false;
    @Widget(title="Alphabet", description="The selected alphabet\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AlphabetEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=AlphabetChoicesProvider.class)
    String alphabet = "roman";
    private static final String[] ALPHABET_VALUES = new String[]{"roman", "arabic", "japanese", "korean", "chinese"};
    @Widget(title="Set Font Size", description="Enable to set the optional field <b>Font Size</b>")
    @ValueReference(value=FontSizeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fontSizeEnabled = false;
    @Widget(title="Font Size", description="The font size of the watermark text\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FontSizeEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    double fontSize = 30.0;
    @Widget(title="Set Rotation", description="Enable to set the optional field <b>Rotation</b>")
    @ValueReference(value=RotationEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean rotationEnabled = false;
    @Widget(title="Rotation", description="The rotation of the watermark in degrees\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=RotationEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    double rotation = 0.0;
    @Widget(title="Set Opacity", description="Enable to set the optional field <b>Opacity</b>")
    @ValueReference(value=OpacityEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean opacityEnabled = false;
    @Widget(title="Opacity", description="The opacity of the watermark (0.0 - 1.0)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=OpacityEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    double opacity = 0.5;
    @Widget(title="Set Width Spacer", description="Enable to set the optional field <b>Width Spacer</b>")
    @ValueReference(value=WidthSpacerEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean widthSpacerEnabled = false;
    @Widget(title="Width Spacer", description="The width spacer between watermark elements\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=WidthSpacerEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int widthSpacer = 50;
    @Widget(title="Set Height Spacer", description="Enable to set the optional field <b>Height Spacer</b>")
    @ValueReference(value=HeightSpacerEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean heightSpacerEnabled = false;
    @Widget(title="Height Spacer", description="The height spacer between watermark elements\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=HeightSpacerEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int heightSpacer = 50;
    @Widget(title="Set Custom Color", description="Enable to set the optional field <b>Custom Color</b>")
    @ValueReference(value=CustomColorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean customColorEnabled = false;
    @Widget(title="Custom Color", description="The color for watermark\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=CustomColorEnabledRef.class, type=Effect.EffectType.SHOW)
    String customColor = "#d3d3d3";
    @Widget(title="Convert PDF to Image", description="Convert the redacted PDF to an image\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Convert_PDF_To_ImagePersistor.class)
    String convertPDFToImage = "false";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=AddWatermarkNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    AddWatermarkNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.watermarkType == null || this.watermarkType.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cWatermark Type\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/security/add-watermark");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "watermarkType", this.watermarkType));
        if (this.watermarkTextEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "watermarkText", this.watermarkText));
        }
        if (this.watermarkImageEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "watermarkImage", new HttpRequestNodeParameters.File(this.watermarkImage)));
        }
        if (this.alphabetEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "alphabet", this.alphabet));
        }
        if (this.fontSizeEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fontSize", this.fontSize));
        }
        if (this.rotationEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "rotation", this.rotation));
        }
        if (this.opacityEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "opacity", this.opacity));
        }
        if (this.widthSpacerEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "widthSpacer", this.widthSpacer));
        }
        if (this.heightSpacerEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "heightSpacer", this.heightSpacer));
        }
        if (this.customColorEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "customColor", this.customColor));
        }
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "convertPDFToImage", this.convertPDFToImage));
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class AddWatermarkNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private AddWatermarkNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class AlphabetChoicesProvider
    implements StringChoicesProvider {
        private AlphabetChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(ALPHABET_VALUES);
        }
    }

    private static final class AlphabetEnabledRef
    implements BooleanReference {
        private AlphabetEnabledRef() {
        }
    }

    private static final class Convert_PDF_To_ImagePersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "convertPDFToImage";

        private Convert_PDF_To_ImagePersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class CustomColorEnabledRef
    implements BooleanReference {
        private CustomColorEnabledRef() {
        }
    }

    private static final class FontSizeEnabledRef
    implements BooleanReference {
        private FontSizeEnabledRef() {
        }
    }

    private static final class HeightSpacerEnabledRef
    implements BooleanReference {
        private HeightSpacerEnabledRef() {
        }
    }

    private static final class OpacityEnabledRef
    implements BooleanReference {
        private OpacityEnabledRef() {
        }
    }

    private static final class RotationEnabledRef
    implements BooleanReference {
        private RotationEnabledRef() {
        }
    }

    private static final class WatermarkImageEnabledRef
    implements BooleanReference {
        private WatermarkImageEnabledRef() {
        }
    }

    private static final class WatermarkTextEnabledRef
    implements BooleanReference {
        private WatermarkTextEnabledRef() {
        }
    }

    private static final class Watermark_TypeChoicesProvider
    implements StringChoicesProvider {
        private Watermark_TypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(WATERMARK_TYPE_VALUES);
        }
    }

    private static final class WidthSpacerEnabledRef
    implements BooleanReference {
        private WidthSpacerEnabledRef() {
        }
    }
}

