/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.autosplitpdf1;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

final class AutoSplitPdf1NodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Set Split Type", description="Enable to set the optional field <b>Split Type</b>")
    @ValueReference(value=SplitTypeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean splitTypeEnabled = false;
    @Widget(title="Split Type", description="Determines the type of split: 0 for size, 1 for page count, 2 for document count\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SplitTypeEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int splitType = 0;
    @Widget(title="Set Split Value", description="Enable to set the optional field <b>Split Value</b>")
    @ValueReference(value=SplitValueEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean splitValueEnabled = false;
    @Widget(title="Split Value", description="Value for split: size in MB (e.g., '10MB') or number of pages (e.g., '5')\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SplitValueEnabledRef.class, type=Effect.EffectType.SHOW)
    String splitValue = "10MB";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=AutoSplitPdf1NodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    AutoSplitPdf1NodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/general/split-by-size-or-count");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        if (this.splitTypeEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "splitType", this.splitType));
        }
        if (this.splitValueEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "splitValue", this.splitValue));
        }
        builder.setResponseType("application/zip");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class AutoSplitPdf1NodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private AutoSplitPdf1NodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class SplitTypeEnabledRef
    implements BooleanReference {
        private SplitTypeEnabledRef() {
        }
    }

    private static final class SplitValueEnabledRef
    implements BooleanReference {
        private SplitValueEnabledRef() {
        }
    }
}

