/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.convertcbztopdf;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;

final class ConvertCbzToPdfNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Set Optimize for Ebook", description="Enable to set the optional field <b>Optimize for Ebook</b>")
    @ValueReference(value=OptimizeForEbookEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean optimizeForEbookEnabled = false;
    @Widget(title="Optimize for Ebook", description="Optimize the output PDF for ebook reading using Ghostscript\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=OptimizeForEbookEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Optimize_For_EbookPersistor.class)
    String optimizeForEbook = "false";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ConvertCbzToPdfNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    ConvertCbzToPdfNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/convert/cbz/pdf");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        if (this.optimizeForEbookEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "optimizeForEbook", this.optimizeForEbook));
        }
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class ConvertCbzToPdfNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ConvertCbzToPdfNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class OptimizeForEbookEnabledRef
    implements BooleanReference {
        private OptimizeForEbookEnabledRef() {
        }
    }

    private static final class Optimize_For_EbookPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "optimizeForEbook";

        private Optimize_For_EbookPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }
}

