/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.convertemltopdf;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.number.NumberInputWidgetValidation;

final class ConvertEmlToPdfNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Set Include Attachments", description="Enable to set the optional field <b>Include Attachments</b>")
    @ValueReference(value=IncludeAttachmentsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean includeAttachmentsEnabled = false;
    @Widget(title="Include Attachments", description="Include email attachments in the PDF output\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=IncludeAttachmentsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Include_AttachmentsPersistor.class)
    String includeAttachments = "false";
    @Widget(title="Set Max Attachment Size MB", description="Enable to set the optional field <b>Max Attachment Size MB</b>")
    @ValueReference(value=MaxAttachmentSizeMBEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean maxAttachmentSizeMBEnabled = false;
    @Widget(title="Max Attachment Size MB", description="Maximum attachment size in MB to include (default 10MB, range: 1-100)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=MaxAttachmentSizeMBEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget(minValidation=Max_Attachment_Size_MBMinValidation.class, maxValidation=Max_Attachment_Size_MBMaxValidation.class)
    int maxAttachmentSizeMB = 1;
    @Widget(title="Set Download Html", description="Enable to set the optional field <b>Download Html</b>")
    @ValueReference(value=DownloadHtmlEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean downloadHtmlEnabled = false;
    @Widget(title="Download Html", description="Download HTML intermediate file instead of PDF\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=DownloadHtmlEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Download_HtmlPersistor.class)
    String downloadHtml = "false";
    @Widget(title="Set Include All Recipients", description="Enable to set the optional field <b>Include All Recipients</b>")
    @ValueReference(value=IncludeAllRecipientsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean includeAllRecipientsEnabled = false;
    @Widget(title="Include All Recipients", description="Include CC and BCC recipients in header (if available)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=IncludeAllRecipientsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Include_All_RecipientsPersistor.class)
    String includeAllRecipients = "false";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ConvertEmlToPdfNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    ConvertEmlToPdfNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/convert/eml/pdf");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        if (this.includeAttachmentsEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "includeAttachments", this.includeAttachments));
        }
        if (this.maxAttachmentSizeMBEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "maxAttachmentSizeMB", this.maxAttachmentSizeMB));
        }
        if (this.downloadHtmlEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "downloadHtml", this.downloadHtml));
        }
        if (this.includeAllRecipientsEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "includeAllRecipients", this.includeAllRecipients));
        }
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class ConvertEmlToPdfNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ConvertEmlToPdfNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class DownloadHtmlEnabledRef
    implements BooleanReference {
        private DownloadHtmlEnabledRef() {
        }
    }

    private static final class Download_HtmlPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "downloadHtml";

        private Download_HtmlPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class IncludeAllRecipientsEnabledRef
    implements BooleanReference {
        private IncludeAllRecipientsEnabledRef() {
        }
    }

    private static final class IncludeAttachmentsEnabledRef
    implements BooleanReference {
        private IncludeAttachmentsEnabledRef() {
        }
    }

    private static final class Include_All_RecipientsPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "includeAllRecipients";

        private Include_All_RecipientsPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class Include_AttachmentsPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "includeAttachments";

        private Include_AttachmentsPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class MaxAttachmentSizeMBEnabledRef
    implements BooleanReference {
        private MaxAttachmentSizeMBEnabledRef() {
        }
    }

    private static final class Max_Attachment_Size_MBMaxValidation
    extends NumberInputWidgetValidation.MaxValidation {
        private Max_Attachment_Size_MBMaxValidation() {
        }

        public double getMax() {
            return 100.0;
        }
    }

    private static final class Max_Attachment_Size_MBMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private Max_Attachment_Size_MBMinValidation() {
        }

        public double getMin() {
            return 1.0;
        }
    }
}

