/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.converttoimage;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

final class ConvertToImageNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Page Numbers", description="The pages to select, Supports ranges (e.g., '1,3,5-9'), or 'all' or functions in the format 'an+b' where 'a' is the multiplier of the page number 'n', and 'b' is a constant (e.g., '2n+1', '3n', '6n-5')\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String pageNumbers = "all";
    @Widget(title="Image Format", description="The output image format\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Image_FormatChoicesProvider.class)
    String imageFormat = "png";
    private static final String[] IMAGE_FORMAT_VALUES = new String[]{"png", "jpeg", "jpg", "gif", "webp"};
    @Widget(title="Single or Multiple", description="Choose between a single image containing all pages or separate images for each page\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Single_Or_MultipleChoicesProvider.class)
    String singleOrMultiple = "multiple";
    private static final String[] SINGLE_OR_MULTIPLE_VALUES = new String[]{"single", "multiple"};
    @Widget(title="Color Type", description="The color type of the output image(s)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Color_TypeChoicesProvider.class)
    String colorType = "color";
    private static final String[] COLOR_TYPE_VALUES = new String[]{"color", "greyscale", "blackwhite"};
    @Widget(title="DPI", description="The DPI (dots per inch) for the output image(s)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    int dpi = 300;
    @Widget(title="Set Include Annotations", description="Enable to set the optional field <b>Include Annotations</b>")
    @ValueReference(value=IncludeAnnotationsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean includeAnnotationsEnabled = false;
    @Widget(title="Include Annotations", description="Include annotations such as comments in the output image(s)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=IncludeAnnotationsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Include_AnnotationsPersistor.class)
    String includeAnnotations = "false";
    private static final String[] RESPONSE_TYPE_VALUES = new String[]{"application/pdf", "application/zip", "image/png", "image/jpeg"};
    private static final String RESPONSE_TYPE_DEFAULT_VALUE = "application/pdf";
    @Widget(title="Response Type", description="Specify the response type. The following response types are available:\n<ul>\n\t<li><tt>application/pdf</tt> \u2013 Single PDF file result</li>\n\t<li><tt>application/zip</tt> \u2013 ZIP archive containing multiple output files</li>\n\t<li><tt>image/png</tt> \u2013 Single image file (PNG)</li>\n\t<li><tt>image/jpeg</tt> \u2013 Single image file (JPEG)</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=ResponseTypeChoicesProvider.class)
    String responseType = "application/pdf";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ConvertToImageNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    ConvertToImageNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.pageNumbers == null || this.pageNumbers.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cPage Numbers\u201d is required.");
        }
        if (this.imageFormat == null || this.imageFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cImage Format\u201d is required.");
        }
        if (this.singleOrMultiple == null || this.singleOrMultiple.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cSingle or Multiple\u201d is required.");
        }
        if (this.colorType == null || this.colorType.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cColor Type\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/convert/pdf/img");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "pageNumbers", this.pageNumbers));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "imageFormat", this.imageFormat));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "singleOrMultiple", this.singleOrMultiple));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "colorType", this.colorType));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "dpi", this.dpi));
        if (this.includeAnnotationsEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "includeAnnotations", this.includeAnnotations));
        }
        builder.setResponseType(this.responseType);
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class Color_TypeChoicesProvider
    implements StringChoicesProvider {
        private Color_TypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(COLOR_TYPE_VALUES);
        }
    }

    private static final class ConvertToImageNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ConvertToImageNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class Image_FormatChoicesProvider
    implements StringChoicesProvider {
        private Image_FormatChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(IMAGE_FORMAT_VALUES);
        }
    }

    private static final class IncludeAnnotationsEnabledRef
    implements BooleanReference {
        private IncludeAnnotationsEnabledRef() {
        }
    }

    private static final class Include_AnnotationsPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "includeAnnotations";

        private Include_AnnotationsPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class ResponseTypeChoicesProvider
    implements StringChoicesProvider {
        private ResponseTypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.stream(RESPONSE_TYPE_VALUES).toList();
        }
    }

    private static final class Single_Or_MultipleChoicesProvider
    implements StringChoicesProvider {
        private Single_Or_MultipleChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SINGLE_OR_MULTIPLE_VALUES);
        }
    }
}

