/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.converttopdf;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

final class ConvertToPdfNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="The input images to be converted to a PDF file\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ArrayWidget(elementLayout=ArrayWidget.ElementLayout.HORIZONTAL_SINGLE_LINE, addButtonText="Add")
    @Persistor(value=File_InputPersistor.class)
    File_Input[] fileInput = new File_Input[]{new File_Input(null)};
    @Widget(title="Fit Option", description="Option to determine how the image will fit onto the page\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Fit_OptionChoicesProvider.class)
    String fitOption = "fillPage";
    private static final String[] FIT_OPTION_VALUES = new String[]{"fillPage", "fitDocumentToImage", "maintainAspectRatio"};
    @Widget(title="Color Type", description="The color type of the output image(s)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Color_TypeChoicesProvider.class)
    String colorType = "color";
    private static final String[] COLOR_TYPE_VALUES = new String[]{"color", "greyscale", "blackwhite"};
    @Widget(title="Auto Rotate", description="Whether to automatically rotate the images to better fit the PDF page\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Auto_RotatePersistor.class)
    String autoRotate = "false";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ConvertToPdfNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    ConvertToPdfNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.length == 0) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.fitOption == null || this.fitOption.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFit Option\u201d is required.");
        }
        if (this.colorType == null || this.colorType.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cColor Type\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/convert/img/pdf");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        Arrays.stream(this.fileInput).forEach(value -> builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(value.text))));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fitOption", this.fitOption));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "colorType", this.colorType));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "autoRotate", this.autoRotate));
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class Auto_RotatePersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "autoRotate";

        private Auto_RotatePersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class Color_TypeChoicesProvider
    implements StringChoicesProvider {
        private Color_TypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(COLOR_TYPE_VALUES);
        }
    }

    private static final class ConvertToPdfNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ConvertToPdfNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    static final class File_Input
    implements WidgetGroup {
        @Widget(title="File", description="")
        @LocalFileReaderWidget
        String text;

        File_Input() {
        }

        File_Input(String text) {
            this.text = text;
        }
    }

    private static final class File_InputPersistor
    implements NodeParametersPersistor<File_Input[]> {
        static final String CONFIG_KEY = "fileInput";

        private File_InputPersistor() {
        }

        public File_Input[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (File_Input[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(File_Input::new).toArray(File_Input[]::new);
        }

        public void save(File_Input[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class Fit_OptionChoicesProvider
    implements StringChoicesProvider {
        private Fit_OptionChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(FIT_OPTION_VALUES);
        }
    }
}

