/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.createbookletimposition;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

final class CreateBookletImpositionNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Pages Per Sheet", description="The number of pages per side for booklet printing (always 2 for proper booklet).\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    double pagesPerSheet = 2.0;
    @Widget(title="Set Add Border", description="Enable to set the optional field <b>Add Border</b>")
    @ValueReference(value=AddBorderEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean addBorderEnabled = false;
    @Widget(title="Add Border", description="Boolean for if you wish to add border around the pages\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AddBorderEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Add_BorderPersistor.class)
    String addBorder = "false";
    @Widget(title="Set Spine Location", description="Enable to set the optional field <b>Spine Location</b>")
    @ValueReference(value=SpineLocationEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean spineLocationEnabled = false;
    @Widget(title="Spine Location", description="The spine location for the booklet.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SpineLocationEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Spine_LocationChoicesProvider.class)
    String spineLocation = "LEFT";
    private static final String[] SPINE_LOCATION_VALUES = new String[]{"LEFT", "RIGHT"};
    @Widget(title="Set Add Gutter", description="Enable to set the optional field <b>Add Gutter</b>")
    @ValueReference(value=AddGutterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean addGutterEnabled = false;
    @Widget(title="Add Gutter", description="Add gutter margin (inner margin for binding)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AddGutterEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Add_GutterPersistor.class)
    String addGutter = "false";
    @Widget(title="Set Gutter Size", description="Enable to set the optional field <b>Gutter Size</b>")
    @ValueReference(value=GutterSizeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean gutterSizeEnabled = false;
    @Widget(title="Gutter Size", description="Gutter margin size in points (used when addGutter is true)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=GutterSizeEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    double gutterSize = 12.0;
    @Widget(title="Set Double Sided", description="Enable to set the optional field <b>Double Sided</b>")
    @ValueReference(value=DoubleSidedEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean doubleSidedEnabled = false;
    @Widget(title="Double Sided", description="Generate both front and back sides (double-sided printing)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=DoubleSidedEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Double_SidedPersistor.class)
    String doubleSided = "false";
    @Widget(title="Set Duplex Pass", description="Enable to set the optional field <b>Duplex Pass</b>")
    @ValueReference(value=DuplexPassEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean duplexPassEnabled = false;
    @Widget(title="Duplex Pass", description="For manual duplex: which pass to generate\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=DuplexPassEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Duplex_PassChoicesProvider.class)
    String duplexPass = "BOTH";
    private static final String[] DUPLEX_PASS_VALUES = new String[]{"BOTH", "FIRST", "SECOND"};
    @Widget(title="Set Flip on Short Edge", description="Enable to set the optional field <b>Flip on Short Edge</b>")
    @ValueReference(value=FlipOnShortEdgeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean flipOnShortEdgeEnabled = false;
    @Widget(title="Flip on Short Edge", description="Flip back sides for short-edge duplex printing (default is long-edge)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FlipOnShortEdgeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Flip_On_Short_EdgePersistor.class)
    String flipOnShortEdge = "false";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateBookletImpositionNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    CreateBookletImpositionNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/general/booklet-imposition");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "pagesPerSheet", this.pagesPerSheet));
        if (this.addBorderEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "addBorder", this.addBorder));
        }
        if (this.spineLocationEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "spineLocation", this.spineLocation));
        }
        if (this.addGutterEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "addGutter", this.addGutter));
        }
        if (this.gutterSizeEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "gutterSize", this.gutterSize));
        }
        if (this.doubleSidedEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "doubleSided", this.doubleSided));
        }
        if (this.duplexPassEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "duplexPass", this.duplexPass));
        }
        if (this.flipOnShortEdgeEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "flipOnShortEdge", this.flipOnShortEdge));
        }
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class AddBorderEnabledRef
    implements BooleanReference {
        private AddBorderEnabledRef() {
        }
    }

    private static final class AddGutterEnabledRef
    implements BooleanReference {
        private AddGutterEnabledRef() {
        }
    }

    private static final class Add_BorderPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "addBorder";

        private Add_BorderPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class Add_GutterPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "addGutter";

        private Add_GutterPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class CreateBookletImpositionNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateBookletImpositionNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class DoubleSidedEnabledRef
    implements BooleanReference {
        private DoubleSidedEnabledRef() {
        }
    }

    private static final class Double_SidedPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "doubleSided";

        private Double_SidedPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class DuplexPassEnabledRef
    implements BooleanReference {
        private DuplexPassEnabledRef() {
        }
    }

    private static final class Duplex_PassChoicesProvider
    implements StringChoicesProvider {
        private Duplex_PassChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(DUPLEX_PASS_VALUES);
        }
    }

    private static final class FlipOnShortEdgeEnabledRef
    implements BooleanReference {
        private FlipOnShortEdgeEnabledRef() {
        }
    }

    private static final class Flip_On_Short_EdgePersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "flipOnShortEdge";

        private Flip_On_Short_EdgePersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class GutterSizeEnabledRef
    implements BooleanReference {
        private GutterSizeEnabledRef() {
        }
    }

    private static final class SpineLocationEnabledRef
    implements BooleanReference {
        private SpineLocationEnabledRef() {
        }
    }

    private static final class Spine_LocationChoicesProvider
    implements StringChoicesProvider {
        private Spine_LocationChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SPINE_LOCATION_VALUES);
        }
    }
}

