/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.croppdf;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

final class CropPdfNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Set X", description="Enable to set the optional field <b>X</b>")
    @ValueReference(value=XEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean xEnabled = false;
    @Widget(title="X", description="The x-coordinate of the top-left corner of the crop area\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=XEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    double x = 0.0;
    @Widget(title="Set Y", description="Enable to set the optional field <b>Y</b>")
    @ValueReference(value=YEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean yEnabled = false;
    @Widget(title="Y", description="The y-coordinate of the top-left corner of the crop area\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=YEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    double y = 0.0;
    @Widget(title="Set Width", description="Enable to set the optional field <b>Width</b>")
    @ValueReference(value=WidthEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean widthEnabled = false;
    @Widget(title="Width", description="The width of the crop area\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=WidthEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    double width = 0.0;
    @Widget(title="Set Height", description="Enable to set the optional field <b>Height</b>")
    @ValueReference(value=HeightEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean heightEnabled = false;
    @Widget(title="Height", description="The height of the crop area\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=HeightEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    double height = 0.0;
    @Widget(title="Set Remove Data Outside Crop", description="Enable to set the optional field <b>Remove Data Outside Crop</b>")
    @ValueReference(value=RemoveDataOutsideCropEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean removeDataOutsideCropEnabled = false;
    @Widget(title="Remove Data Outside Crop", description="Whether to remove text outside the crop area (keeps images)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=RemoveDataOutsideCropEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Remove_Data_Outside_CropPersistor.class)
    String removeDataOutsideCrop = "false";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CropPdfNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    CropPdfNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/general/crop");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        if (this.xEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "x", this.x));
        }
        if (this.yEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "y", this.y));
        }
        if (this.widthEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "width", this.width));
        }
        if (this.heightEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "height", this.height));
        }
        if (this.removeDataOutsideCropEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "removeDataOutsideCrop", this.removeDataOutsideCrop));
        }
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class CropPdfNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CropPdfNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class HeightEnabledRef
    implements BooleanReference {
        private HeightEnabledRef() {
        }
    }

    private static final class RemoveDataOutsideCropEnabledRef
    implements BooleanReference {
        private RemoveDataOutsideCropEnabledRef() {
        }
    }

    private static final class Remove_Data_Outside_CropPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "removeDataOutsideCrop";

        private Remove_Data_Outside_CropPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class WidthEnabledRef
    implements BooleanReference {
        private WidthEnabledRef() {
        }
    }

    private static final class XEnabledRef
    implements BooleanReference {
        private XEnabledRef() {
        }
    }

    private static final class YEnabledRef
    implements BooleanReference {
        private YEnabledRef() {
        }
    }
}

