/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.deletefields;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;

final class DeleteFieldsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File", description="The input PDF file\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String file = "";
    @Widget(title="Set Names", description="Enable to set the optional field <b>Names</b>")
    @ValueReference(value=NamesEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean namesEnabled = false;
    @Widget(title="Names", description="JSON array of field names or objects with a name property, matching the /fields response format\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=NamesEnabledRef.class, type=Effect.EffectType.SHOW)
    String names = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=DeleteFieldsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    DeleteFieldsNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.file == null || this.file.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/form/delete-fields");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "file", new HttpRequestNodeParameters.File(this.file)));
        if (this.namesEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "names", this.names));
        }
        builder.setResponseType("*/*");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class DeleteFieldsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private DeleteFieldsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class NamesEnabledRef
    implements BooleanReference {
        private NamesEnabledRef() {
        }
    }
}

