/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.handledata;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

final class HandleDataNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="The input files\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ArrayWidget(elementLayout=ArrayWidget.ElementLayout.HORIZONTAL_SINGLE_LINE, addButtonText="Add")
    @Persistor(value=File_InputPersistor.class)
    File_Input[] fileInput = new File_Input[]{new File_Input(null)};
    @Widget(title="Json", description="Pipeline configuration in JSON format containing name and operations list\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String json = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=HandleDataNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    HandleDataNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.length == 0) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.json == null || this.json.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cJson\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/pipeline/handleData");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        Arrays.stream(this.fileInput).forEach(value -> builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(value.text))));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "json", this.json));
        builder.setResponseType("application/zip");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    static final class File_Input
    implements WidgetGroup {
        @Widget(title="File", description="")
        @LocalFileReaderWidget
        String text;

        File_Input() {
        }

        File_Input(String text) {
            this.text = text;
        }
    }

    private static final class File_InputPersistor
    implements NodeParametersPersistor<File_Input[]> {
        static final String CONFIG_KEY = "fileInput";

        private File_InputPersistor() {
        }

        public File_Input[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (File_Input[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(File_Input::new).toArray(File_Input[]::new);
        }

        public void save(File_Input[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class HandleDataNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private HandleDataNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

