/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.mergepdfs;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

final class MergePdfsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set File Order", description="Enable to set the optional field <b>File Order</b>")
    @ValueReference(value=FileOrderEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fileOrderEnabled = false;
    @Widget(title="File Order", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FileOrderEnabledRef.class, type=Effect.EffectType.SHOW)
    String fileOrder = null;
    @Widget(title="File Input", description="The input PDF files\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ArrayWidget(elementLayout=ArrayWidget.ElementLayout.HORIZONTAL_SINGLE_LINE, addButtonText="Add")
    @Persistor(value=File_InputPersistor.class)
    File_Input[] fileInput = new File_Input[]{new File_Input(null)};
    @Widget(title="Sort Type", description="The type of sorting to be applied on the input files before merging.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Sort_TypeChoicesProvider.class)
    String sortType = "orderProvided";
    private static final String[] SORT_TYPE_VALUES = new String[]{"orderProvided", "byFileName", "byDateModified", "byDateCreated", "byPDFTitle"};
    @Widget(title="Remove Cert Sign", description="Flag indicating whether to remove certification signatures from the merged PDF. If true, all certification signatures will be removed from the final merged document.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Remove_Cert_SignPersistor.class)
    String removeCertSign = "true";
    @Widget(title="Set Generate Toc", description="Enable to set the optional field <b>Generate Toc</b>")
    @ValueReference(value=GenerateTocEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean generateTocEnabled = false;
    @Widget(title="Generate Toc", description="Flag indicating whether to generate a table of contents for the merged PDF. If true, a table of contents will be created using the input filenames as chapter names.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=GenerateTocEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Generate_TocPersistor.class)
    String generateToc = "false";
    @Widget(title="Set Client File Ids", description="Enable to set the optional field <b>Client File Ids</b>")
    @ValueReference(value=ClientFileIdsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean clientFileIdsEnabled = false;
    @Widget(title="Client File Ids", description="JSON array of client-provided IDs for each uploaded file (same order as fileInput)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ClientFileIdsEnabledRef.class, type=Effect.EffectType.SHOW)
    String clientFileIds = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=MergePdfsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    MergePdfsNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.length == 0) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.sortType == null || this.sortType.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cSort Type\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/general/merge-pdfs");
        if (this.fileOrderEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.QUERY, "fileOrder", this.fileOrder));
        }
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        Arrays.stream(this.fileInput).forEach(value -> builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(value.text))));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "sortType", this.sortType));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "removeCertSign", this.removeCertSign));
        if (this.generateTocEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "generateToc", this.generateToc));
        }
        if (this.clientFileIdsEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "clientFileIds", this.clientFileIds));
        }
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class ClientFileIdsEnabledRef
    implements BooleanReference {
        private ClientFileIdsEnabledRef() {
        }
    }

    private static final class FileOrderEnabledRef
    implements BooleanReference {
        private FileOrderEnabledRef() {
        }
    }

    static final class File_Input
    implements WidgetGroup {
        @Widget(title="File", description="")
        @LocalFileReaderWidget
        String text;

        File_Input() {
        }

        File_Input(String text) {
            this.text = text;
        }
    }

    private static final class File_InputPersistor
    implements NodeParametersPersistor<File_Input[]> {
        static final String CONFIG_KEY = "fileInput";

        private File_InputPersistor() {
        }

        public File_Input[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (File_Input[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(File_Input::new).toArray(File_Input[]::new);
        }

        public void save(File_Input[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class GenerateTocEnabledRef
    implements BooleanReference {
        private GenerateTocEnabledRef() {
        }
    }

    private static final class Generate_TocPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "generateToc";

        private Generate_TocPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class MergePdfsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private MergePdfsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class Remove_Cert_SignPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "removeCertSign";

        private Remove_Cert_SignPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class Sort_TypeChoicesProvider
    implements StringChoicesProvider {
        private Sort_TypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SORT_TYPE_VALUES);
        }
    }
}

