/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.metadata;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

final class MetadataNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Delete All", description="Delete all metadata if set to true\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Delete_AllPersistor.class)
    String deleteAll = "false";
    @Widget(title="Set Author", description="Enable to set the optional field <b>Author</b>")
    @ValueReference(value=AuthorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean authorEnabled = false;
    @Widget(title="Author", description="The author of the document\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AuthorEnabledRef.class, type=Effect.EffectType.SHOW)
    String author = "author";
    @Widget(title="Set Creation Date", description="Enable to set the optional field <b>Creation Date</b>")
    @ValueReference(value=CreationDateEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean creationDateEnabled = false;
    @Widget(title="Creation Date", description="The creation date of the document (format: yyyy/MM/dd HH:mm:ss)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=CreationDateEnabledRef.class, type=Effect.EffectType.SHOW)
    String creationDate = "2023/10/01 12:00:00";
    @Widget(title="Set Creator", description="Enable to set the optional field <b>Creator</b>")
    @ValueReference(value=CreatorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean creatorEnabled = false;
    @Widget(title="Creator", description="The creator of the document\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=CreatorEnabledRef.class, type=Effect.EffectType.SHOW)
    String creator = "creator";
    @Widget(title="Set Keywords", description="Enable to set the optional field <b>Keywords</b>")
    @ValueReference(value=KeywordsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean keywordsEnabled = false;
    @Widget(title="Keywords", description="The keywords for the document\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=KeywordsEnabledRef.class, type=Effect.EffectType.SHOW)
    String keywords = "keywords";
    @Widget(title="Set Modification Date", description="Enable to set the optional field <b>Modification Date</b>")
    @ValueReference(value=ModificationDateEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean modificationDateEnabled = false;
    @Widget(title="Modification Date", description="The modification date of the document (format: yyyy/MM/dd HH:mm:ss)\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ModificationDateEnabledRef.class, type=Effect.EffectType.SHOW)
    String modificationDate = "2023/10/01 12:00:00";
    @Widget(title="Set Producer", description="Enable to set the optional field <b>Producer</b>")
    @ValueReference(value=ProducerEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean producerEnabled = false;
    @Widget(title="Producer", description="The producer of the document\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ProducerEnabledRef.class, type=Effect.EffectType.SHOW)
    String producer = "producer";
    @Widget(title="Set Subject", description="Enable to set the optional field <b>Subject</b>")
    @ValueReference(value=SubjectEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean subjectEnabled = false;
    @Widget(title="Subject", description="The subject of the document\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SubjectEnabledRef.class, type=Effect.EffectType.SHOW)
    String subject = "subject";
    @Widget(title="Set Title", description="Enable to set the optional field <b>Title</b>")
    @ValueReference(value=TitleEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean titleEnabled = false;
    @Widget(title="Title", description="The title of the document\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=TitleEnabledRef.class, type=Effect.EffectType.SHOW)
    String title = "title";
    @Widget(title="Set Trapped", description="Enable to set the optional field <b>Trapped</b>")
    @ValueReference(value=TrappedEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean trappedEnabled = false;
    @Widget(title="Trapped", description="The trapped status of the document\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=TrappedEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=TrappedChoicesProvider.class)
    String trapped = "False";
    private static final String[] TRAPPED_VALUES = new String[]{"True", "False", "Unknown"};
    @Widget(title="Set All Request Params", description="Enable to set the optional field <b>All Request Params</b>")
    @ValueReference(value=AllRequestParamsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean allRequestParamsEnabled = false;
    @Widget(title="All Request Params", description="Map list of key and value of custom parameters. Note these must start with customKey and customValue if they are non-standard\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AllRequestParamsEnabledRef.class, type=Effect.EffectType.SHOW)
    String allRequestParams = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=MetadataNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    MetadataNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/misc/update-metadata");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "deleteAll", this.deleteAll));
        if (this.authorEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "author", this.author));
        }
        if (this.creationDateEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "creationDate", this.creationDate));
        }
        if (this.creatorEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "creator", this.creator));
        }
        if (this.keywordsEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "keywords", this.keywords));
        }
        if (this.modificationDateEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "modificationDate", this.modificationDate));
        }
        if (this.producerEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "producer", this.producer));
        }
        if (this.subjectEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "subject", this.subject));
        }
        if (this.titleEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "title", this.title));
        }
        if (this.trappedEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "trapped", this.trapped));
        }
        if (this.allRequestParamsEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "allRequestParams", this.allRequestParams));
        }
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class AllRequestParamsEnabledRef
    implements BooleanReference {
        private AllRequestParamsEnabledRef() {
        }
    }

    private static final class AuthorEnabledRef
    implements BooleanReference {
        private AuthorEnabledRef() {
        }
    }

    private static final class CreationDateEnabledRef
    implements BooleanReference {
        private CreationDateEnabledRef() {
        }
    }

    private static final class CreatorEnabledRef
    implements BooleanReference {
        private CreatorEnabledRef() {
        }
    }

    private static final class Delete_AllPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "deleteAll";

        private Delete_AllPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class KeywordsEnabledRef
    implements BooleanReference {
        private KeywordsEnabledRef() {
        }
    }

    private static final class MetadataNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private MetadataNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class ModificationDateEnabledRef
    implements BooleanReference {
        private ModificationDateEnabledRef() {
        }
    }

    private static final class ProducerEnabledRef
    implements BooleanReference {
        private ProducerEnabledRef() {
        }
    }

    private static final class SubjectEnabledRef
    implements BooleanReference {
        private SubjectEnabledRef() {
        }
    }

    private static final class TitleEnabledRef
    implements BooleanReference {
        private TitleEnabledRef() {
        }
    }

    private static final class TrappedChoicesProvider
    implements StringChoicesProvider {
        private TrappedChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(TRAPPED_VALUES);
        }
    }

    private static final class TrappedEnabledRef
    implements BooleanReference {
        private TrappedEnabledRef() {
        }
    }
}

