/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.optimizepdf;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

final class OptimizePdfNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Optimize Level", description="The level of optimization to apply to the PDF file. Higher values indicate greater compression but may reduce quality.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    int optimizeLevel = 0;
    @Widget(title="Expected Output Size", description="The expected output size, e.g. '100MB', '25KB', etc.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String expectedOutputSize = "25KB";
    @Widget(title="Linearize", description="Whether to linearize the PDF for faster web viewing. Default is false.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=LinearizePersistor.class)
    String linearize = "false";
    @Widget(title="Normalize", description="Whether to normalize the PDF content for better compatibility. Default is false.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=NormalizePersistor.class)
    String normalize = "false";
    @Widget(title="Grayscale", description="Whether to convert the PDF to grayscale. Default is false.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=GrayscalePersistor.class)
    String grayscale = "false";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=OptimizePdfNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    OptimizePdfNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.expectedOutputSize == null || this.expectedOutputSize.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cExpected Output Size\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/misc/compress-pdf");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "optimizeLevel", this.optimizeLevel));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "expectedOutputSize", this.expectedOutputSize));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "linearize", this.linearize));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "normalize", this.normalize));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "grayscale", this.grayscale));
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class GrayscalePersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "grayscale";

        private GrayscalePersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class LinearizePersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "linearize";

        private LinearizePersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class NormalizePersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "normalize";

        private NormalizePersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class OptimizePdfNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private OptimizePdfNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

