/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.overlaypdfs;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

final class OverlayPdfsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Overlay Files", description="An array of PDF files to be used as overlays on the base PDF. The order in these files is applied based on the selected mode.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ArrayWidget(elementLayout=ArrayWidget.ElementLayout.HORIZONTAL_SINGLE_LINE, addButtonText="Add")
    @Persistor(value=Overlay_FilesPersistor.class)
    Overlay_Files[] overlayFiles = new Overlay_Files[]{new Overlay_Files(null)};
    @Widget(title="Overlay Mode", description="The mode of overlaying: 'SequentialOverlay' for sequential application, 'InterleavedOverlay' for round-robin application, 'FixedRepeatOverlay' for fixed repetition based on provided counts\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Overlay_ModeChoicesProvider.class)
    String overlayMode = OVERLAY_MODE_VALUES[0];
    private static final String[] OVERLAY_MODE_VALUES = new String[]{"SequentialOverlay", "InterleavedOverlay", "FixedRepeatOverlay"};
    @Widget(title="Set Counts", description="Enable to set the optional field <b>Counts</b>")
    @ValueReference(value=CountsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean countsEnabled = false;
    @Widget(title="Counts", description="An array of integers specifying the number of times each corresponding overlay file should be applied in the 'FixedRepeatOverlay' mode. This should match the length of the overlayFiles array.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=CountsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget(elementLayout=ArrayWidget.ElementLayout.HORIZONTAL_SINGLE_LINE, addButtonText="Add")
    @Persistor(value=CountsPersistor.class)
    Counts[] counts = new Counts[]{new Counts(null)};
    @Widget(title="Overlay Position", description="Overlay position 0 is Foregound, 1 is Background\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    double overlayPosition = 0.0;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=OverlayPdfsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    OverlayPdfsNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.overlayFiles == null || this.overlayFiles.length == 0) {
            throw new InvalidSettingsException("Value for \u201cOverlay Files\u201d is required.");
        }
        if (this.overlayMode == null || this.overlayMode.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOverlay Mode\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/general/overlay-pdfs");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        Arrays.stream(this.overlayFiles).forEach(value -> builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "overlayFiles", new HttpRequestNodeParameters.File(value.text))));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "overlayMode", this.overlayMode));
        if (this.countsEnabled) {
            Arrays.stream(this.counts).forEach(value -> builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "counts", value.text)));
        }
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "overlayPosition", this.overlayPosition));
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    static final class Counts
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Counts() {
        }

        Counts(String text) {
            this.text = text;
        }
    }

    private static final class CountsEnabledRef
    implements BooleanReference {
        private CountsEnabledRef() {
        }
    }

    private static final class CountsPersistor
    implements NodeParametersPersistor<Counts[]> {
        static final String CONFIG_KEY = "counts";

        private CountsPersistor() {
        }

        public Counts[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Counts[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Counts::new).toArray(Counts[]::new);
        }

        public void save(Counts[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class OverlayPdfsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private OverlayPdfsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    static final class Overlay_Files
    implements WidgetGroup {
        @Widget(title="File", description="")
        @LocalFileReaderWidget
        String text;

        Overlay_Files() {
        }

        Overlay_Files(String text) {
            this.text = text;
        }
    }

    private static final class Overlay_FilesPersistor
    implements NodeParametersPersistor<Overlay_Files[]> {
        static final String CONFIG_KEY = "overlayFiles";

        private Overlay_FilesPersistor() {
        }

        public Overlay_Files[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Overlay_Files[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Overlay_Files::new).toArray(Overlay_Files[]::new);
        }

        public void save(Overlay_Files[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class Overlay_ModeChoicesProvider
    implements StringChoicesProvider {
        private Overlay_ModeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(OVERLAY_MODE_VALUES);
        }
    }
}

