/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.processpdftortfortxt;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

final class ProcessPdfToRTForTXTNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Output Format", description="The output Text or RTF format\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Output_FormatChoicesProvider.class)
    String outputFormat = OUTPUT_FORMAT_VALUES[0];
    private static final String[] OUTPUT_FORMAT_VALUES = new String[]{"rtf", "txt"};
    private static final String[] RESPONSE_TYPE_VALUES = new String[]{"text/plain", "application/rtf"};
    private static final String RESPONSE_TYPE_DEFAULT_VALUE = "text/plain";
    @Widget(title="Response Type", description="Specify the response type. The following response types are available:\n<ul>\n\t<li><tt>text/plain</tt> \u2013 Plain text content extracted from PDF</li>\n\t<li><tt>application/rtf</tt> \u2013 Rich Text Format document</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=ResponseTypeChoicesProvider.class)
    String responseType = "text/plain";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ProcessPdfToRTForTXTNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    ProcessPdfToRTForTXTNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.outputFormat == null || this.outputFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOutput Format\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/convert/pdf/text");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "outputFormat", this.outputFormat));
        builder.setResponseType(this.responseType);
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class Output_FormatChoicesProvider
    implements StringChoicesProvider {
        private Output_FormatChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(OUTPUT_FORMAT_VALUES);
        }
    }

    private static final class ProcessPdfToRTForTXTNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ProcessPdfToRTForTXTNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class ResponseTypeChoicesProvider
    implements StringChoicesProvider {
        private ResponseTypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.stream(RESPONSE_TYPE_VALUES).toList();
        }
    }
}

