/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.processpdfwithocr;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

final class ProcessPdfWithOCRNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Languages", description="List of languages to use in OCR processing, e.g., 'eng', 'deu'\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ArrayWidget(elementLayout=ArrayWidget.ElementLayout.HORIZONTAL_SINGLE_LINE, addButtonText="Add")
    @Persistor(value=LanguagesPersistor.class)
    Languages[] languages = new Languages[]{new Languages("[&quot;eng&quot;]")};
    @Widget(title="Set Sidecar", description="Enable to set the optional field <b>Sidecar</b>")
    @ValueReference(value=SidecarEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sidecarEnabled = false;
    @Widget(title="Sidecar", description="Include OCR text in a sidecar text file if set to true\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SidecarEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=SidecarPersistor.class)
    String sidecar = "false";
    @Widget(title="Set Deskew", description="Enable to set the optional field <b>Deskew</b>")
    @ValueReference(value=DeskewEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean deskewEnabled = false;
    @Widget(title="Deskew", description="Deskew the input file if set to true\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=DeskewEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=DeskewPersistor.class)
    String deskew = "false";
    @Widget(title="Set Clean", description="Enable to set the optional field <b>Clean</b>")
    @ValueReference(value=CleanEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean cleanEnabled = false;
    @Widget(title="Clean", description="Clean the input file if set to true\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=CleanEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=CleanPersistor.class)
    String clean = "false";
    @Widget(title="Set Clean Final", description="Enable to set the optional field <b>Clean Final</b>")
    @ValueReference(value=CleanFinalEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean cleanFinalEnabled = false;
    @Widget(title="Clean Final", description="Clean the final output if set to true\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=CleanFinalEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Clean_FinalPersistor.class)
    String cleanFinal = "false";
    @Widget(title="Ocr Type", description="Specify the OCR type, e.g., 'skip-text', 'force-ocr', or 'Normal'\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Ocr_TypeChoicesProvider.class)
    String ocrType = OCR_TYPE_VALUES[0];
    private static final String[] OCR_TYPE_VALUES = new String[]{"skip-text", "force-ocr", "Normal"};
    @Widget(title="Ocr Render Type", description="Specify the OCR render type, either 'hocr' or 'sandwich'\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Ocr_Render_TypeChoicesProvider.class)
    String ocrRenderType = "hocr";
    private static final String[] OCR_RENDER_TYPE_VALUES = new String[]{"hocr", "sandwich"};
    @Widget(title="Set Remove Images After", description="Enable to set the optional field <b>Remove Images After</b>")
    @ValueReference(value=RemoveImagesAfterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean removeImagesAfterEnabled = false;
    @Widget(title="Remove Images After", description="Remove images from the output PDF if set to true\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=RemoveImagesAfterEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Remove_Images_AfterPersistor.class)
    String removeImagesAfter = "false";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ProcessPdfWithOCRNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    ProcessPdfWithOCRNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.languages == null || this.languages.length == 0) {
            throw new InvalidSettingsException("Value for \u201cLanguages\u201d is required.");
        }
        if (this.ocrType == null || this.ocrType.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOcr Type\u201d is required.");
        }
        if (this.ocrRenderType == null || this.ocrRenderType.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cOcr Render Type\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/misc/ocr-pdf");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        Arrays.stream(this.languages).forEach(value -> builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "languages", value.text)));
        if (this.sidecarEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "sidecar", this.sidecar));
        }
        if (this.deskewEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "deskew", this.deskew));
        }
        if (this.cleanEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "clean", this.clean));
        }
        if (this.cleanFinalEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "cleanFinal", this.cleanFinal));
        }
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "ocrType", this.ocrType));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "ocrRenderType", this.ocrRenderType));
        if (this.removeImagesAfterEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "removeImagesAfter", this.removeImagesAfter));
        }
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class CleanEnabledRef
    implements BooleanReference {
        private CleanEnabledRef() {
        }
    }

    private static final class CleanFinalEnabledRef
    implements BooleanReference {
        private CleanFinalEnabledRef() {
        }
    }

    private static final class CleanPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "clean";

        private CleanPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class Clean_FinalPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "cleanFinal";

        private Clean_FinalPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class DeskewEnabledRef
    implements BooleanReference {
        private DeskewEnabledRef() {
        }
    }

    private static final class DeskewPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "deskew";

        private DeskewPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    static final class Languages
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Languages() {
        }

        Languages(String text) {
            this.text = text;
        }
    }

    private static final class LanguagesPersistor
    implements NodeParametersPersistor<Languages[]> {
        static final String CONFIG_KEY = "languages";

        private LanguagesPersistor() {
        }

        public Languages[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Languages[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Languages::new).toArray(Languages[]::new);
        }

        public void save(Languages[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class Ocr_Render_TypeChoicesProvider
    implements StringChoicesProvider {
        private Ocr_Render_TypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(OCR_RENDER_TYPE_VALUES);
        }
    }

    private static final class Ocr_TypeChoicesProvider
    implements StringChoicesProvider {
        private Ocr_TypeChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(OCR_TYPE_VALUES);
        }
    }

    private static final class ProcessPdfWithOCRNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ProcessPdfWithOCRNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class RemoveImagesAfterEnabledRef
    implements BooleanReference {
        private RemoveImagesAfterEnabledRef() {
        }
    }

    private static final class Remove_Images_AfterPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "removeImagesAfter";

        private Remove_Images_AfterPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class SidecarEnabledRef
    implements BooleanReference {
        private SidecarEnabledRef() {
        }
    }

    private static final class SidecarPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "sidecar";

        private SidecarPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }
}

