/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.removeblankpages;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;
import org.knime.node.parameters.widget.number.NumberInputWidgetValidation;

final class RemoveBlankPagesNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Threshold", description="The threshold value to determine blank pages\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget(minValidation=ThresholdMinValidation.class, maxValidation=ThresholdMaxValidation.class)
    int threshold = 10;
    @Widget(title="White Percent", description="The percentage of white color on a page to consider it as blank\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget(minValidation=White_PercentMinValidation.class, maxValidation=White_PercentMaxValidation.class)
    double whitePercent = 99.9;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=RemoveBlankPagesNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    RemoveBlankPagesNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/misc/remove-blanks");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "threshold", this.threshold));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "whitePercent", this.whitePercent));
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class RemoveBlankPagesNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private RemoveBlankPagesNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class ThresholdMaxValidation
    extends NumberInputWidgetValidation.MaxValidation {
        private ThresholdMaxValidation() {
        }

        public double getMax() {
            return 255.0;
        }
    }

    private static final class ThresholdMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private ThresholdMinValidation() {
        }

        public double getMin() {
            return 0.0;
        }
    }

    private static final class White_PercentMaxValidation
    extends NumberInputWidgetValidation.MaxValidation {
        private White_PercentMaxValidation() {
        }

        public double getMax() {
            return 100.0;
        }
    }

    private static final class White_PercentMinValidation
    extends NumberInputWidgetValidation.MinValidation {
        private White_PercentMinValidation() {
        }

        public double getMin() {
            return 0.1;
        }
    }
}

