/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.removepassword;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;

final class RemovePasswordNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Set Password", description="Enable to set the optional field <b>Password</b>")
    @ValueReference(value=PasswordEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean passwordEnabled = false;
    @Widget(title="Password", description="The password of the PDF file\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PasswordEnabledRef.class, type=Effect.EffectType.SHOW)
    String password = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=RemovePasswordNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    RemovePasswordNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/security/remove-password");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        if (this.passwordEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "password", this.password));
        }
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class PasswordEnabledRef
    implements BooleanReference {
        private PasswordEnabledRef() {
        }
    }

    private static final class RemovePasswordNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private RemovePasswordNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

