/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.stirlingpdf.v1.operation.replaceandinvertcolor;

import com.nodepit.nodes.stirlingpdf.v1.HttpRequestNodeParameters;
import com.nodepit.nodes.stirlingpdf.v1.NodeParametersUtils;
import com.nodepit.nodes.stirlingpdf.v1.ResponseMapper;
import com.nodepit.nodes.stirlingpdf.v1.SimpleResponseMapper;
import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.webui.node.dialog.defaultdialog.internal.file.LocalFileReaderWidget;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;

final class ReplaceAndInvertColorNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="File Input", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @LocalFileReaderWidget
    String fileInput = "";
    @Widget(title="Replace and Invert Option", description="Replace and Invert color options of a pdf.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=Replace_And_Invert_OptionChoicesProvider.class)
    String replaceAndInvertOption = "HIGH_CONTRAST_COLOR";
    private static final String[] REPLACE_AND_INVERT_OPTION_VALUES = new String[]{"HIGH_CONTRAST_COLOR", "CUSTOM_COLOR", "FULL_INVERSION", "COLOR_SPACE_CONVERSION", "HIGH_CONTRAST_COLOR", "CUSTOM_COLOR", "FULL_INVERSION", "COLOR_SPACE_CONVERSION"};
    @Widget(title="High Contrast Color Combination", description="If HIGH_CONTRAST_COLOR option selected, then pick the default color option for text and background.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @ChoicesProvider(value=High_Contrast_Color_CombinationChoicesProvider.class)
    String highContrastColorCombination = "WHITE_TEXT_ON_BLACK";
    private static final String[] HIGH_CONTRAST_COLOR_COMBINATION_VALUES = new String[]{"WHITE_TEXT_ON_BLACK", "BLACK_TEXT_ON_WHITE", "YELLOW_TEXT_ON_BLACK", "GREEN_TEXT_ON_BLACK", "WHITE_TEXT_ON_BLACK", "BLACK_TEXT_ON_WHITE", "YELLOW_TEXT_ON_BLACK", "GREEN_TEXT_ON_BLACK"};
    @Widget(title="Set Back Ground Color", description="Enable to set the optional field <b>Back Ground Color</b>")
    @ValueReference(value=BackGroundColorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean backGroundColorEnabled = false;
    @Widget(title="Back Ground Color", description="If CUSTOM_COLOR option selected, then pick the custom color for background. Expected color value should be 24bit decimal value of a color\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=BackGroundColorEnabledRef.class, type=Effect.EffectType.SHOW)
    String backGroundColor = null;
    @Widget(title="Set Text Color", description="Enable to set the optional field <b>Text Color</b>")
    @ValueReference(value=TextColorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean textColorEnabled = false;
    @Widget(title="Text Color", description="If CUSTOM_COLOR option selected, then pick the custom color for text. Expected color value should be 24bit decimal value of a color\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=TextColorEnabledRef.class, type=Effect.EffectType.SHOW)
    String textColor = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=ReplaceAndInvertColorNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new SimpleResponseMapper.Builder().withBody().build()};

    ReplaceAndInvertColorNodeParameters() {
    }

    public void validate() throws InvalidSettingsException {
        if (this.fileInput == null || this.fileInput.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cFile Input\u201d is required.");
        }
        if (this.replaceAndInvertOption == null || this.replaceAndInvertOption.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cReplace and Invert Option\u201d is required.");
        }
        if (this.highContrastColorCombination == null || this.highContrastColorCombination.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cHigh Contrast Color Combination\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public HttpRequestNodeParameters.HttpRequestParams getRequestParams() {
        HttpRequestNodeParameters.HttpRequestParams.Builder builder = new HttpRequestNodeParameters.HttpRequestParams.Builder();
        builder.setMethod("POST");
        builder.setPath("/api/v1/misc/replace-invert-pdf");
        builder.setBodyType(HttpRequestNodeParameters.BodyType.MULTIPART);
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "fileInput", new HttpRequestNodeParameters.File(this.fileInput)));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "replaceAndInvertOption", this.replaceAndInvertOption));
        builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "highContrastColorCombination", this.highContrastColorCombination));
        if (this.backGroundColorEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "backGroundColor", this.backGroundColor));
        }
        if (this.textColorEnabled) {
            builder.addParam(new HttpRequestNodeParameters.Param(HttpRequestNodeParameters.ParamType.BODY, "textColor", this.textColor));
        }
        builder.setResponseType("application/pdf");
        builder.pickResponseMapper(MAPPERS, this.resultFormat);
        return builder.build();
    }

    private static final class BackGroundColorEnabledRef
    implements BooleanReference {
        private BackGroundColorEnabledRef() {
        }
    }

    private static final class High_Contrast_Color_CombinationChoicesProvider
    implements StringChoicesProvider {
        private High_Contrast_Color_CombinationChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(HIGH_CONTRAST_COLOR_COMBINATION_VALUES);
        }
    }

    private static final class ReplaceAndInvertColorNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private ReplaceAndInvertColorNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class Replace_And_Invert_OptionChoicesProvider
    implements StringChoicesProvider {
        private Replace_And_Invert_OptionChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(REPLACE_AND_INVERT_OPTION_VALUES);
        }
    }

    private static final class TextColorEnabledRef
    implements BooleanReference {
        private TextColorEnabledRef() {
        }
    }
}

